@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TopicSubscription].
 */
@PulumiTagMarker
public class TopicSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TopicSubscriptionArgs = TopicSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TopicSubscriptionArgsBuilder.() -> Unit) {
        val builder = TopicSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TopicSubscription {
        val builtJavaResource = com.pulumi.aws.sns.TopicSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TopicSubscription(builtJavaResource)
    }
}

/**
 * Provides a resource for subscribing to SNS topics. Requires that an SNS topic exist for the subscription to attach to. This resource allows you to automatically place messages sent to SNS topics in SQS queues, send them as HTTP(S) POST requests to a given endpoint, send SMS messages, or notify devices / applications. The most likely use case for provider users will probably be SQS queues.
 * > **NOTE:** If the SNS topic and SQS queue are in different AWS regions, the `aws.sns.TopicSubscription` must use an AWS provider that is in the same region as the SNS topic. If the `aws.sns.TopicSubscription` uses a provider with a different region than the SNS topic, this provider will fail to create the subscription.
 * > **NOTE:** Setup of cross-account subscriptions from SNS topics to SQS queues requires the provider to have access to BOTH accounts.
 * > **NOTE:** If an SNS topic and SQS queue are in different AWS accounts but the same region, the `aws.sns.TopicSubscription` must use the AWS provider for the account with the SQS queue. If `aws.sns.TopicSubscription` uses a Provider with a different account than the SQS queue, this provider creates the subscription but does not keep state and tries to re-create the subscription at every `apply`.
 * > **NOTE:** If an SNS topic and SQS queue are in different AWS accounts and different AWS regions, the subscription needs to be initiated from the account with the SQS queue but in the region of the SNS topic.
 * > **NOTE:** You cannot unsubscribe to a subscription that is pending confirmation. If you use `email`, `email-json`, or `http`/`https` (without auto-confirmation enabled), until the subscription is confirmed (e.g., outside of this provider), AWS does not allow this provider to delete / unsubscribe the subscription. If you `destroy` an unconfirmed subscription, this provider will remove the subscription from its state but the subscription will still exist in AWS. However, if you delete an SNS topic, SNS [deletes all the subscriptions](https://docs.aws.amazon.com/sns/latest/dg/sns-delete-subscription-topic.html) associated with the topic. Also, you can import a subscription after confirmation and then have the capability to delete it.
 * ## Example Usage
 * You can directly supply a topic and ARN by hand in the `topic_arn` property along with the queue ARN:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.TopicSubscription;
 * import com.pulumi.aws.sns.TopicSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userUpdatesSqsTarget = new TopicSubscription("userUpdatesSqsTarget", TopicSubscriptionArgs.builder()
 *             .endpoint("arn:aws:sqs:us-west-2:432981146916:queue-too")
 *             .protocol("sqs")
 *             .topic("arn:aws:sns:us-west-2:432981146916:user-updates-topic")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SNS Topic Subscriptions using the subscription `arn`. For example:
 * ```sh
 *  $ pulumi import aws:sns/topicSubscription:TopicSubscription user_updates_sqs_target arn:aws:sns:us-west-2:0123456789012:my-topic:8a21d249-4329-4871-acc6-7be709c6ea7f
 * ```
 *
 */
public class TopicSubscription internal constructor(
    override val javaResource: com.pulumi.aws.sns.TopicSubscription,
) : KotlinCustomResource(javaResource, TopicSubscriptionMapper) {
    /**
     * ARN of the subscription.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Integer indicating number of minutes to wait in retrying mode for fetching subscription arn before marking it as failure. Only applicable for http and https protocols. Default is `1`.
     */
    public val confirmationTimeoutInMinutes: Output<Int>?
        get() = javaResource.confirmationTimeoutInMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the subscription confirmation request was authenticated.
     */
    public val confirmationWasAuthenticated: Output<Boolean>
        get() = javaResource.confirmationWasAuthenticated().applyValue({ args0 -> args0 })

    /**
     * JSON String with the delivery policy (retries, backoff, etc.) that will be used in the subscription - this only applies to HTTP/S subscriptions. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html) for more details.
     */
    public val deliveryPolicy: Output<String>?
        get() = javaResource.deliveryPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Endpoint to send data to. The contents vary with the protocol. See details below.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * Whether the endpoint is capable of [auto confirming subscription](http://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.html#SendMessageToHttp.prepare) (e.g., PagerDuty). Default is `false`.
     */
    public val endpointAutoConfirms: Output<Boolean>?
        get() = javaResource.endpointAutoConfirms().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * JSON String with the filter policy that will be used in the subscription to filter messages seen by the target resource. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-filtering.html) for more details.
     */
    public val filterPolicy: Output<String>?
        get() = javaResource.filterPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the `filter_policy` applies to `MessageAttributes` (default) or `MessageBody`.
     */
    public val filterPolicyScope: Output<String>
        get() = javaResource.filterPolicyScope().applyValue({ args0 -> args0 })

    /**
     * AWS account ID of the subscription's owner.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Whether the subscription has not been confirmed.
     */
    public val pendingConfirmation: Output<Boolean>
        get() = javaResource.pendingConfirmation().applyValue({ args0 -> args0 })

    /**
     * Protocol to use. Valid values are: `sqs`, `sms`, `lambda`, `firehose`, and `application`. Protocols `email`, `email-json`, `http` and `https` are also valid but partially supported. See details below.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * Whether to enable raw message delivery (the original message is directly passed, not wrapped in JSON with the original message in the message property). Default is `false`.
     */
    public val rawMessageDelivery: Output<Boolean>?
        get() = javaResource.rawMessageDelivery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * JSON String with the redrive policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-dead-letter-queues.html#how-messages-moved-into-dead-letter-queue) for more details.
     */
    public val redrivePolicy: Output<String>?
        get() = javaResource.redrivePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * JSON String with the archived message replay policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-subscriber.html) for more details.
     */
    public val replayPolicy: Output<String>?
        get() = javaResource.replayPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the IAM role to publish to Kinesis Data Firehose delivery stream. Refer to [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html).
     */
    public val subscriptionRoleArn: Output<String>?
        get() = javaResource.subscriptionRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the SNS topic to subscribe to.
     * The following arguments are optional:
     */
    public val topic: Output<String>
        get() = javaResource.topic().applyValue({ args0 -> args0 })
}

public object TopicSubscriptionMapper : ResourceMapper<TopicSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sns.TopicSubscription::class == javaResource::class

    override fun map(javaResource: Resource): TopicSubscription = TopicSubscription(
        javaResource as
            com.pulumi.aws.sns.TopicSubscription,
    )
}

/**
 * @see [TopicSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TopicSubscription].
 */
public suspend fun topicSubscription(
    name: String,
    block: suspend TopicSubscriptionResourceBuilder.() -> Unit,
): TopicSubscription {
    val builder = TopicSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TopicSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun topicSubscription(name: String): TopicSubscription {
    val builder = TopicSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
