@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin

import com.pulumi.aws.sns.TopicSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource for subscribing to SNS topics. Requires that an SNS topic exist for the subscription to attach to. This resource allows you to automatically place messages sent to SNS topics in SQS queues, send them as HTTP(S) POST requests to a given endpoint, send SMS messages, or notify devices / applications. The most likely use case for provider users will probably be SQS queues.
 * > **NOTE:** If the SNS topic and SQS queue are in different AWS regions, the `aws.sns.TopicSubscription` must use an AWS provider that is in the same region as the SNS topic. If the `aws.sns.TopicSubscription` uses a provider with a different region than the SNS topic, this provider will fail to create the subscription.
 * > **NOTE:** Setup of cross-account subscriptions from SNS topics to SQS queues requires the provider to have access to BOTH accounts.
 * > **NOTE:** If an SNS topic and SQS queue are in different AWS accounts but the same region, the `aws.sns.TopicSubscription` must use the AWS provider for the account with the SQS queue. If `aws.sns.TopicSubscription` uses a Provider with a different account than the SQS queue, this provider creates the subscription but does not keep state and tries to re-create the subscription at every `apply`.
 * > **NOTE:** If an SNS topic and SQS queue are in different AWS accounts and different AWS regions, the subscription needs to be initiated from the account with the SQS queue but in the region of the SNS topic.
 * > **NOTE:** You cannot unsubscribe to a subscription that is pending confirmation. If you use `email`, `email-json`, or `http`/`https` (without auto-confirmation enabled), until the subscription is confirmed (e.g., outside of this provider), AWS does not allow this provider to delete / unsubscribe the subscription. If you `destroy` an unconfirmed subscription, this provider will remove the subscription from its state but the subscription will still exist in AWS. However, if you delete an SNS topic, SNS [deletes all the subscriptions](https://docs.aws.amazon.com/sns/latest/dg/sns-delete-subscription-topic.html) associated with the topic. Also, you can import a subscription after confirmation and then have the capability to delete it.
 * ## Example Usage
 * You can directly supply a topic and ARN by hand in the `topic_arn` property along with the queue ARN:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.TopicSubscription;
 * import com.pulumi.aws.sns.TopicSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userUpdatesSqsTarget = new TopicSubscription("userUpdatesSqsTarget", TopicSubscriptionArgs.builder()
 *             .endpoint("arn:aws:sqs:us-west-2:432981146916:queue-too")
 *             .protocol("sqs")
 *             .topic("arn:aws:sns:us-west-2:432981146916:user-updates-topic")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SNS Topic Subscriptions using the subscription `arn`. For example:
 * ```sh
 *  $ pulumi import aws:sns/topicSubscription:TopicSubscription user_updates_sqs_target arn:aws:sns:us-west-2:0123456789012:my-topic:8a21d249-4329-4871-acc6-7be709c6ea7f
 * ```
 * @property confirmationTimeoutInMinutes Integer indicating number of minutes to wait in retrying mode for fetching subscription arn before marking it as failure. Only applicable for http and https protocols. Default is `1`.
 * @property deliveryPolicy JSON String with the delivery policy (retries, backoff, etc.) that will be used in the subscription - this only applies to HTTP/S subscriptions. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html) for more details.
 * @property endpoint Endpoint to send data to. The contents vary with the protocol. See details below.
 * @property endpointAutoConfirms Whether the endpoint is capable of [auto confirming subscription](http://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.html#SendMessageToHttp.prepare) (e.g., PagerDuty). Default is `false`.
 * @property filterPolicy JSON String with the filter policy that will be used in the subscription to filter messages seen by the target resource. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-filtering.html) for more details.
 * @property filterPolicyScope Whether the `filter_policy` applies to `MessageAttributes` (default) or `MessageBody`.
 * @property protocol Protocol to use. Valid values are: `sqs`, `sms`, `lambda`, `firehose`, and `application`. Protocols `email`, `email-json`, `http` and `https` are also valid but partially supported. See details below.
 * @property rawMessageDelivery Whether to enable raw message delivery (the original message is directly passed, not wrapped in JSON with the original message in the message property). Default is `false`.
 * @property redrivePolicy JSON String with the redrive policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-dead-letter-queues.html#how-messages-moved-into-dead-letter-queue) for more details.
 * @property replayPolicy JSON String with the archived message replay policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-subscriber.html) for more details.
 * @property subscriptionRoleArn ARN of the IAM role to publish to Kinesis Data Firehose delivery stream. Refer to [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html).
 * @property topic ARN of the SNS topic to subscribe to.
 * The following arguments are optional:
 */
public data class TopicSubscriptionArgs(
    public val confirmationTimeoutInMinutes: Output<Int>? = null,
    public val deliveryPolicy: Output<String>? = null,
    public val endpoint: Output<String>? = null,
    public val endpointAutoConfirms: Output<Boolean>? = null,
    public val filterPolicy: Output<String>? = null,
    public val filterPolicyScope: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val rawMessageDelivery: Output<Boolean>? = null,
    public val redrivePolicy: Output<String>? = null,
    public val replayPolicy: Output<String>? = null,
    public val subscriptionRoleArn: Output<String>? = null,
    public val topic: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sns.TopicSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.sns.TopicSubscriptionArgs =
        com.pulumi.aws.sns.TopicSubscriptionArgs.builder()
            .confirmationTimeoutInMinutes(confirmationTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .deliveryPolicy(deliveryPolicy?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .endpointAutoConfirms(endpointAutoConfirms?.applyValue({ args0 -> args0 }))
            .filterPolicy(filterPolicy?.applyValue({ args0 -> args0 }))
            .filterPolicyScope(filterPolicyScope?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .rawMessageDelivery(rawMessageDelivery?.applyValue({ args0 -> args0 }))
            .redrivePolicy(redrivePolicy?.applyValue({ args0 -> args0 }))
            .replayPolicy(replayPolicy?.applyValue({ args0 -> args0 }))
            .subscriptionRoleArn(subscriptionRoleArn?.applyValue({ args0 -> args0 }))
            .topic(topic?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicSubscriptionArgs].
 */
@PulumiTagMarker
public class TopicSubscriptionArgsBuilder internal constructor() {
    private var confirmationTimeoutInMinutes: Output<Int>? = null

    private var deliveryPolicy: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var endpointAutoConfirms: Output<Boolean>? = null

    private var filterPolicy: Output<String>? = null

    private var filterPolicyScope: Output<String>? = null

    private var protocol: Output<String>? = null

    private var rawMessageDelivery: Output<Boolean>? = null

    private var redrivePolicy: Output<String>? = null

    private var replayPolicy: Output<String>? = null

    private var subscriptionRoleArn: Output<String>? = null

    private var topic: Output<String>? = null

    /**
     * @param value Integer indicating number of minutes to wait in retrying mode for fetching subscription arn before marking it as failure. Only applicable for http and https protocols. Default is `1`.
     */
    @JvmName("rklutndpybcucpkr")
    public suspend fun confirmationTimeoutInMinutes(`value`: Output<Int>) {
        this.confirmationTimeoutInMinutes = value
    }

    /**
     * @param value JSON String with the delivery policy (retries, backoff, etc.) that will be used in the subscription - this only applies to HTTP/S subscriptions. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html) for more details.
     */
    @JvmName("tkmsupovljlxrfch")
    public suspend fun deliveryPolicy(`value`: Output<String>) {
        this.deliveryPolicy = value
    }

    /**
     * @param value Endpoint to send data to. The contents vary with the protocol. See details below.
     */
    @JvmName("vwhftxyenxnirxxr")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Whether the endpoint is capable of [auto confirming subscription](http://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.html#SendMessageToHttp.prepare) (e.g., PagerDuty). Default is `false`.
     */
    @JvmName("iyfdtkstbxvokxat")
    public suspend fun endpointAutoConfirms(`value`: Output<Boolean>) {
        this.endpointAutoConfirms = value
    }

    /**
     * @param value JSON String with the filter policy that will be used in the subscription to filter messages seen by the target resource. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-filtering.html) for more details.
     */
    @JvmName("xcardditppafpyqh")
    public suspend fun filterPolicy(`value`: Output<String>) {
        this.filterPolicy = value
    }

    /**
     * @param value Whether the `filter_policy` applies to `MessageAttributes` (default) or `MessageBody`.
     */
    @JvmName("iwsvxyqkikjyghpy")
    public suspend fun filterPolicyScope(`value`: Output<String>) {
        this.filterPolicyScope = value
    }

    /**
     * @param value Protocol to use. Valid values are: `sqs`, `sms`, `lambda`, `firehose`, and `application`. Protocols `email`, `email-json`, `http` and `https` are also valid but partially supported. See details below.
     */
    @JvmName("dicoopuuxicbctdr")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Whether to enable raw message delivery (the original message is directly passed, not wrapped in JSON with the original message in the message property). Default is `false`.
     */
    @JvmName("bjhsnmkemxeqewii")
    public suspend fun rawMessageDelivery(`value`: Output<Boolean>) {
        this.rawMessageDelivery = value
    }

    /**
     * @param value JSON String with the redrive policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-dead-letter-queues.html#how-messages-moved-into-dead-letter-queue) for more details.
     */
    @JvmName("qihppsiuqvbdeoxg")
    public suspend fun redrivePolicy(`value`: Output<String>) {
        this.redrivePolicy = value
    }

    /**
     * @param value JSON String with the archived message replay policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-subscriber.html) for more details.
     */
    @JvmName("apqmmnptppdkdppd")
    public suspend fun replayPolicy(`value`: Output<String>) {
        this.replayPolicy = value
    }

    /**
     * @param value ARN of the IAM role to publish to Kinesis Data Firehose delivery stream. Refer to [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html).
     */
    @JvmName("igaoreduunpvwbju")
    public suspend fun subscriptionRoleArn(`value`: Output<String>) {
        this.subscriptionRoleArn = value
    }

    /**
     * @param value ARN of the SNS topic to subscribe to.
     * The following arguments are optional:
     */
    @JvmName("kjpyybmblcdwkdqi")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value Integer indicating number of minutes to wait in retrying mode for fetching subscription arn before marking it as failure. Only applicable for http and https protocols. Default is `1`.
     */
    @JvmName("qrivvplvsraqspnb")
    public suspend fun confirmationTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confirmationTimeoutInMinutes = mapped
    }

    /**
     * @param value JSON String with the delivery policy (retries, backoff, etc.) that will be used in the subscription - this only applies to HTTP/S subscriptions. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/DeliveryPolicies.html) for more details.
     */
    @JvmName("lhxyjcxdegmvyfir")
    public suspend fun deliveryPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryPolicy = mapped
    }

    /**
     * @param value Endpoint to send data to. The contents vary with the protocol. See details below.
     */
    @JvmName("hcrautfviviesata")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Whether the endpoint is capable of [auto confirming subscription](http://docs.aws.amazon.com/sns/latest/dg/SendMessageToHttp.html#SendMessageToHttp.prepare) (e.g., PagerDuty). Default is `false`.
     */
    @JvmName("ivqpoibmexgrbcbh")
    public suspend fun endpointAutoConfirms(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointAutoConfirms = mapped
    }

    /**
     * @param value JSON String with the filter policy that will be used in the subscription to filter messages seen by the target resource. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-filtering.html) for more details.
     */
    @JvmName("maxfdnikioagtreg")
    public suspend fun filterPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterPolicy = mapped
    }

    /**
     * @param value Whether the `filter_policy` applies to `MessageAttributes` (default) or `MessageBody`.
     */
    @JvmName("qpkeconqiexpebmq")
    public suspend fun filterPolicyScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterPolicyScope = mapped
    }

    /**
     * @param value Protocol to use. Valid values are: `sqs`, `sms`, `lambda`, `firehose`, and `application`. Protocols `email`, `email-json`, `http` and `https` are also valid but partially supported. See details below.
     */
    @JvmName("hdyaeuqcvjymaqdl")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Whether to enable raw message delivery (the original message is directly passed, not wrapped in JSON with the original message in the message property). Default is `false`.
     */
    @JvmName("osfdsdxbwqachkxf")
    public suspend fun rawMessageDelivery(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rawMessageDelivery = mapped
    }

    /**
     * @param value JSON String with the redrive policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-dead-letter-queues.html#how-messages-moved-into-dead-letter-queue) for more details.
     */
    @JvmName("jsuadbqqwirnftvg")
    public suspend fun redrivePolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redrivePolicy = mapped
    }

    /**
     * @param value JSON String with the archived message replay policy that will be used in the subscription. Refer to the [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/message-archiving-and-replay-subscriber.html) for more details.
     */
    @JvmName("wwbnvksnnhlgkthr")
    public suspend fun replayPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replayPolicy = mapped
    }

    /**
     * @param value ARN of the IAM role to publish to Kinesis Data Firehose delivery stream. Refer to [SNS docs](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html).
     */
    @JvmName("rgasugqeyyaimhul")
    public suspend fun subscriptionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionRoleArn = mapped
    }

    /**
     * @param value ARN of the SNS topic to subscribe to.
     * The following arguments are optional:
     */
    @JvmName("yyjdvmxjotpxrnkx")
    public suspend fun topic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    internal fun build(): TopicSubscriptionArgs = TopicSubscriptionArgs(
        confirmationTimeoutInMinutes = confirmationTimeoutInMinutes,
        deliveryPolicy = deliveryPolicy,
        endpoint = endpoint,
        endpointAutoConfirms = endpointAutoConfirms,
        filterPolicy = filterPolicy,
        filterPolicyScope = filterPolicyScope,
        protocol = protocol,
        rawMessageDelivery = rawMessageDelivery,
        redrivePolicy = redrivePolicy,
        replayPolicy = replayPolicy,
        subscriptionRoleArn = subscriptionRoleArn,
        topic = topic,
    )
}
