@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sns.kotlin.inputs

import com.pulumi.aws.sns.inputs.GetTopicPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTopic.
 * @property name Friendly name of the topic to match.
 */
public data class GetTopicPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.sns.inputs.GetTopicPlainArgs> {
    override fun toJava(): com.pulumi.aws.sns.inputs.GetTopicPlainArgs =
        com.pulumi.aws.sns.inputs.GetTopicPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTopicPlainArgs].
 */
@PulumiTagMarker
public class GetTopicPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Friendly name of the topic to match.
     */
    @JvmName("fnuhbfwastwfcbta")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetTopicPlainArgs = GetTopicPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
