@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [QueuePolicy].
 */
@PulumiTagMarker
public class QueuePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QueuePolicyArgs = QueuePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QueuePolicyArgsBuilder.() -> Unit) {
        val builder = QueuePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): QueuePolicy {
        val builtJavaResource = com.pulumi.aws.sqs.QueuePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return QueuePolicy(builtJavaResource)
    }
}

/**
 * Allows you to set a policy of an SQS Queue
 * while referencing ARN of the queue within the policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sqs.QueuePolicy;
 * import com.pulumi.aws.sqs.QueuePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue");
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("First")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("sqs:SendMessage")
 *                 .resources(queue.arn())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("ArnEquals")
 *                     .variable("aws:SourceArn")
 *                     .values(aws_sns_topic.example().arn())
 *                     .build())
 *                 .build())
 *             .build());
 *         var testQueuePolicy = new QueuePolicy("testQueuePolicy", QueuePolicyArgs.builder()
 *             .queueUrl(queue.id())
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testPolicyDocument -> testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SQS Queue Policies using the queue URL. For example:
 * ```sh
 *  $ pulumi import aws:sqs/queuePolicy:QueuePolicy test https://queue.amazonaws.com/0123456789012/myqueue
 * ```
 *
 */
public class QueuePolicy internal constructor(
    override val javaResource: com.pulumi.aws.sqs.QueuePolicy,
) : KotlinCustomResource(javaResource, QueuePolicyMapper) {
    /**
     * The JSON policy for the SQS queue.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The URL of the SQS Queue to which to attach the policy
     */
    public val queueUrl: Output<String>
        get() = javaResource.queueUrl().applyValue({ args0 -> args0 })
}

public object QueuePolicyMapper : ResourceMapper<QueuePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sqs.QueuePolicy::class == javaResource::class

    override fun map(javaResource: Resource): QueuePolicy = QueuePolicy(
        javaResource as
            com.pulumi.aws.sqs.QueuePolicy,
    )
}

/**
 * @see [QueuePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [QueuePolicy].
 */
public suspend fun queuePolicy(name: String, block: suspend QueuePolicyResourceBuilder.() -> Unit):
    QueuePolicy {
    val builder = QueuePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [QueuePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun queuePolicy(name: String): QueuePolicy {
    val builder = QueuePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
