@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin

import com.pulumi.aws.sqs.QueuePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Allows you to set a policy of an SQS Queue
 * while referencing ARN of the queue within the policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sqs.QueuePolicy;
 * import com.pulumi.aws.sqs.QueuePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue");
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("First")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("sqs:SendMessage")
 *                 .resources(queue.arn())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("ArnEquals")
 *                     .variable("aws:SourceArn")
 *                     .values(aws_sns_topic.example().arn())
 *                     .build())
 *                 .build())
 *             .build());
 *         var testQueuePolicy = new QueuePolicy("testQueuePolicy", QueuePolicyArgs.builder()
 *             .queueUrl(queue.id())
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testPolicyDocument -> testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SQS Queue Policies using the queue URL. For example:
 * ```sh
 *  $ pulumi import aws:sqs/queuePolicy:QueuePolicy test https://queue.amazonaws.com/0123456789012/myqueue
 * ```
 * @property policy The JSON policy for the SQS queue.
 * @property queueUrl The URL of the SQS Queue to which to attach the policy
 */
public data class QueuePolicyArgs(
    public val policy: Output<String>? = null,
    public val queueUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sqs.QueuePolicyArgs> {
    override fun toJava(): com.pulumi.aws.sqs.QueuePolicyArgs =
        com.pulumi.aws.sqs.QueuePolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .queueUrl(queueUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueuePolicyArgs].
 */
@PulumiTagMarker
public class QueuePolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var queueUrl: Output<String>? = null

    /**
     * @param value The JSON policy for the SQS queue.
     */
    @JvmName("syjodtrytatspjbm")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The URL of the SQS Queue to which to attach the policy
     */
    @JvmName("rcjaoglkaeborhdm")
    public suspend fun queueUrl(`value`: Output<String>) {
        this.queueUrl = value
    }

    /**
     * @param value The JSON policy for the SQS queue.
     */
    @JvmName("wqfmketisshckksx")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The URL of the SQS Queue to which to attach the policy
     */
    @JvmName("sicgyqhlhbmorhrr")
    public suspend fun queueUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueUrl = mapped
    }

    internal fun build(): QueuePolicyArgs = QueuePolicyArgs(
        policy = policy,
        queueUrl = queueUrl,
    )
}
