@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RedriveAllowPolicy].
 */
@PulumiTagMarker
public class RedriveAllowPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RedriveAllowPolicyArgs = RedriveAllowPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RedriveAllowPolicyArgsBuilder.() -> Unit) {
        val builder = RedriveAllowPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RedriveAllowPolicy {
        val builtJavaResource = com.pulumi.aws.sqs.RedriveAllowPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RedriveAllowPolicy(builtJavaResource)
    }
}

/**
 * Provides a SQS Queue Redrive Allow Policy resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import com.pulumi.aws.sqs.RedriveAllowPolicy;
 * import com.pulumi.aws.sqs.RedriveAllowPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleQueue = new Queue("exampleQueue");
 *         var src = new Queue("src", QueueArgs.builder()
 *             .redrivePolicy(exampleQueue.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("deadLetterTargetArn", arn),
 *                     jsonProperty("maxReceiveCount", 4)
 *                 ))))
 *             .build());
 *         var exampleRedriveAllowPolicy = new RedriveAllowPolicy("exampleRedriveAllowPolicy", RedriveAllowPolicyArgs.builder()
 *             .queueUrl(exampleQueue.id())
 *             .redriveAllowPolicy(src.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("redrivePermission", "byQueue"),
 *                     jsonProperty("sourceQueueArns", jsonArray(arn))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SQS Queue Redrive Allow Policies using the queue URL. For example:
 * ```sh
 *  $ pulumi import aws:sqs/redriveAllowPolicy:RedriveAllowPolicy test https://queue.amazonaws.com/0123456789012/myqueue
 * ```
 *
 */
public class RedriveAllowPolicy internal constructor(
    override val javaResource: com.pulumi.aws.sqs.RedriveAllowPolicy,
) : KotlinCustomResource(javaResource, RedriveAllowPolicyMapper) {
    /**
     * The URL of the SQS Queue to which to attach the policy
     */
    public val queueUrl: Output<String>
        get() = javaResource.queueUrl().applyValue({ args0 -> args0 })

    /**
     * The JSON redrive allow policy for the SQS queue. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
     */
    public val redriveAllowPolicy: Output<String>
        get() = javaResource.redriveAllowPolicy().applyValue({ args0 -> args0 })
}

public object RedriveAllowPolicyMapper : ResourceMapper<RedriveAllowPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sqs.RedriveAllowPolicy::class == javaResource::class

    override fun map(javaResource: Resource): RedriveAllowPolicy = RedriveAllowPolicy(
        javaResource as
            com.pulumi.aws.sqs.RedriveAllowPolicy,
    )
}

/**
 * @see [RedriveAllowPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RedriveAllowPolicy].
 */
public suspend fun redriveAllowPolicy(
    name: String,
    block: suspend RedriveAllowPolicyResourceBuilder.() -> Unit,
): RedriveAllowPolicy {
    val builder = RedriveAllowPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RedriveAllowPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun redriveAllowPolicy(name: String): RedriveAllowPolicy {
    val builder = RedriveAllowPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
