@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin

import com.pulumi.aws.sqs.RedriveAllowPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a SQS Queue Redrive Allow Policy resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import com.pulumi.aws.sqs.RedriveAllowPolicy;
 * import com.pulumi.aws.sqs.RedriveAllowPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleQueue = new Queue("exampleQueue");
 *         var src = new Queue("src", QueueArgs.builder()
 *             .redrivePolicy(exampleQueue.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("deadLetterTargetArn", arn),
 *                     jsonProperty("maxReceiveCount", 4)
 *                 ))))
 *             .build());
 *         var exampleRedriveAllowPolicy = new RedriveAllowPolicy("exampleRedriveAllowPolicy", RedriveAllowPolicyArgs.builder()
 *             .queueUrl(exampleQueue.id())
 *             .redriveAllowPolicy(src.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("redrivePermission", "byQueue"),
 *                     jsonProperty("sourceQueueArns", jsonArray(arn))
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SQS Queue Redrive Allow Policies using the queue URL. For example:
 * ```sh
 *  $ pulumi import aws:sqs/redriveAllowPolicy:RedriveAllowPolicy test https://queue.amazonaws.com/0123456789012/myqueue
 * ```
 * @property queueUrl The URL of the SQS Queue to which to attach the policy
 * @property redriveAllowPolicy The JSON redrive allow policy for the SQS queue. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
 */
public data class RedriveAllowPolicyArgs(
    public val queueUrl: Output<String>? = null,
    public val redriveAllowPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sqs.RedriveAllowPolicyArgs> {
    override fun toJava(): com.pulumi.aws.sqs.RedriveAllowPolicyArgs =
        com.pulumi.aws.sqs.RedriveAllowPolicyArgs.builder()
            .queueUrl(queueUrl?.applyValue({ args0 -> args0 }))
            .redriveAllowPolicy(redriveAllowPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RedriveAllowPolicyArgs].
 */
@PulumiTagMarker
public class RedriveAllowPolicyArgsBuilder internal constructor() {
    private var queueUrl: Output<String>? = null

    private var redriveAllowPolicy: Output<String>? = null

    /**
     * @param value The URL of the SQS Queue to which to attach the policy
     */
    @JvmName("lhuttobyrgoloeri")
    public suspend fun queueUrl(`value`: Output<String>) {
        this.queueUrl = value
    }

    /**
     * @param value The JSON redrive allow policy for the SQS queue. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
     */
    @JvmName("qtghrflxrpvucrtx")
    public suspend fun redriveAllowPolicy(`value`: Output<String>) {
        this.redriveAllowPolicy = value
    }

    /**
     * @param value The URL of the SQS Queue to which to attach the policy
     */
    @JvmName("wfkvfhywocusukks")
    public suspend fun queueUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueUrl = mapped
    }

    /**
     * @param value The JSON redrive allow policy for the SQS queue. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
     */
    @JvmName("epqbaebnsyvwsusw")
    public suspend fun redriveAllowPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redriveAllowPolicy = mapped
    }

    internal fun build(): RedriveAllowPolicyArgs = RedriveAllowPolicyArgs(
        queueUrl = queueUrl,
        redriveAllowPolicy = redriveAllowPolicy,
    )
}
