@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RedrivePolicy].
 */
@PulumiTagMarker
public class RedrivePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RedrivePolicyArgs = RedrivePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RedrivePolicyArgsBuilder.() -> Unit) {
        val builder = RedrivePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RedrivePolicy {
        val builtJavaResource = com.pulumi.aws.sqs.RedrivePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RedrivePolicy(builtJavaResource)
    }
}

/**
 * Allows you to set a redrive policy of an SQS Queue
 * while referencing ARN of the dead letter queue inside the redrive policy.
 * This is useful when you want to set a dedicated
 * dead letter queue for a standard or FIFO queue, but need
 * the dead letter queue to exist before setting the redrive policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import com.pulumi.aws.sqs.RedrivePolicy;
 * import com.pulumi.aws.sqs.RedrivePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue");
 *         var ddl = new Queue("ddl", QueueArgs.builder()
 *             .redriveAllowPolicy(queue.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("redrivePermission", "byQueue"),
 *                     jsonProperty("sourceQueueArns", jsonArray(arn))
 *                 ))))
 *             .build());
 *         var redrivePolicy = new RedrivePolicy("redrivePolicy", RedrivePolicyArgs.builder()
 *             .queueUrl(queue.id())
 *             .redrivePolicy(ddl.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("deadLetterTargetArn", arn),
 *                     jsonProperty("maxReceiveCount", 4)
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SQS Queue Redrive Policies using the queue URL. For example:
 * ```sh
 *  $ pulumi import aws:sqs/redrivePolicy:RedrivePolicy test https://queue.amazonaws.com/0123456789012/myqueue
 * ```
 *
 */
public class RedrivePolicy internal constructor(
    override val javaResource: com.pulumi.aws.sqs.RedrivePolicy,
) : KotlinCustomResource(javaResource, RedrivePolicyMapper) {
    /**
     * The URL of the SQS Queue to which to attach the policy
     */
    public val queueUrl: Output<String>
        get() = javaResource.queueUrl().applyValue({ args0 -> args0 })

    /**
     * The JSON redrive policy for the SQS queue. Accepts two key/val pairs: `deadLetterTargetArn` and `maxReceiveCount`. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
     */
    public val redrivePolicy: Output<String>
        get() = javaResource.redrivePolicy().applyValue({ args0 -> args0 })
}

public object RedrivePolicyMapper : ResourceMapper<RedrivePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sqs.RedrivePolicy::class == javaResource::class

    override fun map(javaResource: Resource): RedrivePolicy = RedrivePolicy(
        javaResource as
            com.pulumi.aws.sqs.RedrivePolicy,
    )
}

/**
 * @see [RedrivePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RedrivePolicy].
 */
public suspend fun redrivePolicy(
    name: String,
    block: suspend RedrivePolicyResourceBuilder.() -> Unit,
): RedrivePolicy {
    val builder = RedrivePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RedrivePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun redrivePolicy(name: String): RedrivePolicy {
    val builder = RedrivePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
