@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin

import com.pulumi.aws.sqs.RedrivePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Allows you to set a redrive policy of an SQS Queue
 * while referencing ARN of the dead letter queue inside the redrive policy.
 * This is useful when you want to set a dedicated
 * dead letter queue for a standard or FIFO queue, but need
 * the dead letter queue to exist before setting the redrive policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import com.pulumi.aws.sqs.RedrivePolicy;
 * import com.pulumi.aws.sqs.RedrivePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue");
 *         var ddl = new Queue("ddl", QueueArgs.builder()
 *             .redriveAllowPolicy(queue.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("redrivePermission", "byQueue"),
 *                     jsonProperty("sourceQueueArns", jsonArray(arn))
 *                 ))))
 *             .build());
 *         var redrivePolicy = new RedrivePolicy("redrivePolicy", RedrivePolicyArgs.builder()
 *             .queueUrl(queue.id())
 *             .redrivePolicy(ddl.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("deadLetterTargetArn", arn),
 *                     jsonProperty("maxReceiveCount", 4)
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SQS Queue Redrive Policies using the queue URL. For example:
 * ```sh
 *  $ pulumi import aws:sqs/redrivePolicy:RedrivePolicy test https://queue.amazonaws.com/0123456789012/myqueue
 * ```
 * @property queueUrl The URL of the SQS Queue to which to attach the policy
 * @property redrivePolicy The JSON redrive policy for the SQS queue. Accepts two key/val pairs: `deadLetterTargetArn` and `maxReceiveCount`. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
 */
public data class RedrivePolicyArgs(
    public val queueUrl: Output<String>? = null,
    public val redrivePolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sqs.RedrivePolicyArgs> {
    override fun toJava(): com.pulumi.aws.sqs.RedrivePolicyArgs =
        com.pulumi.aws.sqs.RedrivePolicyArgs.builder()
            .queueUrl(queueUrl?.applyValue({ args0 -> args0 }))
            .redrivePolicy(redrivePolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RedrivePolicyArgs].
 */
@PulumiTagMarker
public class RedrivePolicyArgsBuilder internal constructor() {
    private var queueUrl: Output<String>? = null

    private var redrivePolicy: Output<String>? = null

    /**
     * @param value The URL of the SQS Queue to which to attach the policy
     */
    @JvmName("aptgkhybadqarnki")
    public suspend fun queueUrl(`value`: Output<String>) {
        this.queueUrl = value
    }

    /**
     * @param value The JSON redrive policy for the SQS queue. Accepts two key/val pairs: `deadLetterTargetArn` and `maxReceiveCount`. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
     */
    @JvmName("rinoddjnkpmashqk")
    public suspend fun redrivePolicy(`value`: Output<String>) {
        this.redrivePolicy = value
    }

    /**
     * @param value The URL of the SQS Queue to which to attach the policy
     */
    @JvmName("eefujluuehiyyems")
    public suspend fun queueUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueUrl = mapped
    }

    /**
     * @param value The JSON redrive policy for the SQS queue. Accepts two key/val pairs: `deadLetterTargetArn` and `maxReceiveCount`. Learn more in the [Amazon SQS dead-letter queues documentation](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html).
     */
    @JvmName("akdftkfpvibwvrlj")
    public suspend fun redrivePolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redrivePolicy = mapped
    }

    internal fun build(): RedrivePolicyArgs = RedrivePolicyArgs(
        queueUrl = queueUrl,
        redrivePolicy = redrivePolicy,
    )
}
