@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin

import com.pulumi.aws.sqs.SqsFunctions.getQueuePlain
import com.pulumi.aws.sqs.SqsFunctions.getQueuesPlain
import com.pulumi.aws.sqs.kotlin.inputs.GetQueuePlainArgs
import com.pulumi.aws.sqs.kotlin.inputs.GetQueuePlainArgsBuilder
import com.pulumi.aws.sqs.kotlin.inputs.GetQueuesPlainArgs
import com.pulumi.aws.sqs.kotlin.inputs.GetQueuesPlainArgsBuilder
import com.pulumi.aws.sqs.kotlin.outputs.GetQueueResult
import com.pulumi.aws.sqs.kotlin.outputs.GetQueuesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.sqs.kotlin.outputs.GetQueueResult.Companion.toKotlin as getQueueResultToKotlin
import com.pulumi.aws.sqs.kotlin.outputs.GetQueuesResult.Companion.toKotlin as getQueuesResultToKotlin

public object SqsFunctions {
    /**
     * Use this data source to get the ARN and URL of queue in AWS Simple Queue Service (SQS).
     * By using this data source, you can reference SQS queues without having to hardcode
     * the ARNs as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sqs.SqsFunctions;
     * import com.pulumi.aws.sqs.inputs.GetQueueArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SqsFunctions.getQueue(GetQueueArgs.builder()
     *             .name("queue")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getQueue.
     * @return A collection of values returned by getQueue.
     */
    public suspend fun getQueue(argument: GetQueuePlainArgs): GetQueueResult =
        getQueueResultToKotlin(getQueuePlain(argument.toJava()).await())

    /**
     * @see [getQueue].
     * @param name Name of the queue to match.
     * @param tags Map of tags for the resource.
     * @return A collection of values returned by getQueue.
     */
    public suspend fun getQueue(name: String, tags: Map<String, String>? = null): GetQueueResult {
        val argument = GetQueuePlainArgs(
            name = name,
            tags = tags,
        )
        return getQueueResultToKotlin(getQueuePlain(argument.toJava()).await())
    }

    /**
     * @see [getQueue].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sqs&#46;kotlin&#46;inputs&#46;GetQueuePlainArgs].
     * @return A collection of values returned by getQueue.
     */
    public suspend fun getQueue(argument: suspend GetQueuePlainArgsBuilder.() -> Unit):
        GetQueueResult {
        val builder = GetQueuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueueResultToKotlin(getQueuePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS SQS (Simple Queue) Queues.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sqs.SqsFunctions;
     * import com.pulumi.aws.sqs.inputs.GetQueuesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SqsFunctions.getQueues(GetQueuesArgs.builder()
     *             .queueNamePrefix("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getQueues.
     * @return A collection of values returned by getQueues.
     */
    public suspend fun getQueues(argument: GetQueuesPlainArgs): GetQueuesResult =
        getQueuesResultToKotlin(getQueuesPlain(argument.toJava()).await())

    /**
     * @see [getQueues].
     * @param queueNamePrefix A string to use for filtering the list results. Only those queues whose name begins with the specified string are returned. Queue URLs and names are case-sensitive.
     * @return A collection of values returned by getQueues.
     */
    public suspend fun getQueues(queueNamePrefix: String? = null): GetQueuesResult {
        val argument = GetQueuesPlainArgs(
            queueNamePrefix = queueNamePrefix,
        )
        return getQueuesResultToKotlin(getQueuesPlain(argument.toJava()).await())
    }

    /**
     * @see [getQueues].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sqs&#46;kotlin&#46;inputs&#46;GetQueuesPlainArgs].
     * @return A collection of values returned by getQueues.
     */
    public suspend fun getQueues(argument: suspend GetQueuesPlainArgsBuilder.() -> Unit):
        GetQueuesResult {
        val builder = GetQueuesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueuesResultToKotlin(getQueuesPlain(builtArgument.toJava()).await())
    }
}
