@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sqs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getQueue.
 * @property arn ARN of the queue.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property tags Map of tags for the resource.
 * @property url URL of the queue.
 */
public data class GetQueueResult(
    public val arn: String,
    public val id: String,
    public val name: String,
    public val tags: Map<String, String>,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sqs.outputs.GetQueueResult): GetQueueResult =
            GetQueueResult(
                arn = javaType.arn(),
                id = javaType.id(),
                name = javaType.name(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                url = javaType.url(),
            )
    }
}
