@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Activation].
 */
@PulumiTagMarker
public class ActivationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ActivationArgs = ActivationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ActivationArgsBuilder.() -> Unit) {
        val builder = ActivationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Activation {
        val builtJavaResource = com.pulumi.aws.ssm.Activation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Activation(builtJavaResource)
    }
}

/**
 * Registers an on-premises server or virtual machine with Amazon EC2 so that it can be managed using Run Command.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.ssm.Activation;
 * import com.pulumi.aws.ssm.ActivationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ssm.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testAttach = new RolePolicyAttachment("testAttach", RolePolicyAttachmentArgs.builder()
 *             .role(testRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore")
 *             .build());
 *         var foo = new Activation("foo", ActivationArgs.builder()
 *             .description("Test")
 *             .iamRole(testRole.id())
 *             .registrationLimit("5")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testAttach)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS SSM Activation using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/activation:Activation example e488f2f6-e686-4afb-8a04-ef6dfEXAMPLE
 * ```
 *  -> __Note:__ The `activation_code` attribute cannot be imported.
 */
public class Activation internal constructor(
    override val javaResource: com.pulumi.aws.ssm.Activation,
) : KotlinCustomResource(javaResource, ActivationMapper) {
    /**
     * The code the system generates when it processes the activation.
     */
    public val activationCode: Output<String>
        get() = javaResource.activationCode().applyValue({ args0 -> args0 })

    /**
     * The description of the resource that you want to register.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * UTC timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) by which this activation request should expire. The default value is 24 hours from resource creation time. This provider will only perform drift detection of its value when present in a configuration.
     */
    public val expirationDate: Output<String>
        get() = javaResource.expirationDate().applyValue({ args0 -> args0 })

    /**
     * If the current activation has expired.
     */
    public val expired: Output<Boolean>
        get() = javaResource.expired().applyValue({ args0 -> args0 })

    /**
     * The IAM Role to attach to the managed instance.
     */
    public val iamRole: Output<String>
        get() = javaResource.iamRole().applyValue({ args0 -> args0 })

    /**
     * The default name of the registered managed instance.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of managed instances that are currently registered using this activation.
     */
    public val registrationCount: Output<Int>
        get() = javaResource.registrationCount().applyValue({ args0 -> args0 })

    /**
     * The maximum number of managed instances you want to register. The default value is 1 instance.
     */
    public val registrationLimit: Output<Int>?
        get() = javaResource.registrationLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ActivationMapper : ResourceMapper<Activation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.Activation::class == javaResource::class

    override fun map(javaResource: Resource): Activation = Activation(
        javaResource as
            com.pulumi.aws.ssm.Activation,
    )
}

/**
 * @see [Activation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Activation].
 */
public suspend fun activation(name: String, block: suspend ActivationResourceBuilder.() -> Unit):
    Activation {
    val builder = ActivationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Activation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun activation(name: String): Activation {
    val builder = ActivationResourceBuilder()
    builder.name(name)
    return builder.build()
}
