@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.ActivationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Registers an on-premises server or virtual machine with Amazon EC2 so that it can be managed using Run Command.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.ssm.Activation;
 * import com.pulumi.aws.ssm.ActivationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ssm.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testAttach = new RolePolicyAttachment("testAttach", RolePolicyAttachmentArgs.builder()
 *             .role(testRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore")
 *             .build());
 *         var foo = new Activation("foo", ActivationArgs.builder()
 *             .description("Test")
 *             .iamRole(testRole.id())
 *             .registrationLimit("5")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testAttach)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS SSM Activation using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/activation:Activation example e488f2f6-e686-4afb-8a04-ef6dfEXAMPLE
 * ```
 *  -> __Note:__ The `activation_code` attribute cannot be imported.
 * @property description The description of the resource that you want to register.
 * @property expirationDate UTC timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) by which this activation request should expire. The default value is 24 hours from resource creation time. This provider will only perform drift detection of its value when present in a configuration.
 * @property iamRole The IAM Role to attach to the managed instance.
 * @property name The default name of the registered managed instance.
 * @property registrationLimit The maximum number of managed instances you want to register. The default value is 1 instance.
 * @property tags A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ActivationArgs(
    public val description: Output<String>? = null,
    public val expirationDate: Output<String>? = null,
    public val iamRole: Output<String>? = null,
    public val name: Output<String>? = null,
    public val registrationLimit: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.ActivationArgs> {
    override fun toJava(): com.pulumi.aws.ssm.ActivationArgs =
        com.pulumi.aws.ssm.ActivationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .expirationDate(expirationDate?.applyValue({ args0 -> args0 }))
            .iamRole(iamRole?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .registrationLimit(registrationLimit?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ActivationArgs].
 */
@PulumiTagMarker
public class ActivationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var expirationDate: Output<String>? = null

    private var iamRole: Output<String>? = null

    private var name: Output<String>? = null

    private var registrationLimit: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the resource that you want to register.
     */
    @JvmName("rfolcfmpqkhrqrno")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value UTC timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) by which this activation request should expire. The default value is 24 hours from resource creation time. This provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("bkrooetsypupbacq")
    public suspend fun expirationDate(`value`: Output<String>) {
        this.expirationDate = value
    }

    /**
     * @param value The IAM Role to attach to the managed instance.
     */
    @JvmName("lkohbjjsfvmubfok")
    public suspend fun iamRole(`value`: Output<String>) {
        this.iamRole = value
    }

    /**
     * @param value The default name of the registered managed instance.
     */
    @JvmName("lsnxfphrygufygyk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The maximum number of managed instances you want to register. The default value is 1 instance.
     */
    @JvmName("omhhkeuichqdmevr")
    public suspend fun registrationLimit(`value`: Output<Int>) {
        this.registrationLimit = value
    }

    /**
     * @param value A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sxfohhkkwjpqwuxs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the resource that you want to register.
     */
    @JvmName("qvwkfbljqbhevlnr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value UTC timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) by which this activation request should expire. The default value is 24 hours from resource creation time. This provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("xlwljnxmtkatwqwi")
    public suspend fun expirationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationDate = mapped
    }

    /**
     * @param value The IAM Role to attach to the managed instance.
     */
    @JvmName("ikbwdmpqrcnhfdec")
    public suspend fun iamRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRole = mapped
    }

    /**
     * @param value The default name of the registered managed instance.
     */
    @JvmName("kfdtsbfjqcuhkcni")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The maximum number of managed instances you want to register. The default value is 1 instance.
     */
    @JvmName("ojekwcadstxckksk")
    public suspend fun registrationLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationLimit = mapped
    }

    /**
     * @param value A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vkexjfjoxeyxivur")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the object. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("paaqhxkycqlamfxh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ActivationArgs = ActivationArgs(
        description = description,
        expirationDate = expirationDate,
        iamRole = iamRole,
        name = name,
        registrationLimit = registrationLimit,
        tags = tags,
    )
}
