@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.kotlin.outputs.AssociationOutputLocation
import com.pulumi.aws.ssm.kotlin.outputs.AssociationTarget
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ssm.kotlin.outputs.AssociationOutputLocation.Companion.toKotlin as associationOutputLocationToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.AssociationTarget.Companion.toKotlin as associationTargetToKotlin

/**
 * Builder for [Association].
 */
@PulumiTagMarker
public class AssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssociationArgs = AssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssociationArgsBuilder.() -> Unit) {
        val builder = AssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Association {
        val builtJavaResource = com.pulumi.aws.ssm.Association(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Association(builtJavaResource)
    }
}

/**
 * Associates an SSM Document to an instance or EC2 tag.
 * ## Example Usage
 * ### Create an association for a specific instance
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Association;
 * import com.pulumi.aws.ssm.AssociationArgs;
 * import com.pulumi.aws.ssm.inputs.AssociationTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Association("example", AssociationArgs.builder()
 *             .targets(AssociationTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(aws_instance.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create an association for all managed instances in an AWS account
 * To target all managed instances in an AWS account, set the `key` as `"InstanceIds"` with `values` set as `["*"]`. This example also illustrates how to use an Amazon owned SSM document named `AmazonCloudWatch-ManageAgent`.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Association;
 * import com.pulumi.aws.ssm.AssociationArgs;
 * import com.pulumi.aws.ssm.inputs.AssociationTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Association("example", AssociationArgs.builder()
 *             .targets(AssociationTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values("*")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create an association for a specific tag
 * This example shows how to target all managed instances that are assigned a tag key of `Environment` and value of `Development`.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Association;
 * import com.pulumi.aws.ssm.AssociationArgs;
 * import com.pulumi.aws.ssm.inputs.AssociationTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Association("example", AssociationArgs.builder()
 *             .targets(AssociationTargetArgs.builder()
 *                 .key("tag:Environment")
 *                 .values("Development")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create an association with a specific schedule
 * This example shows how to schedule an association in various ways.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Association;
 * import com.pulumi.aws.ssm.AssociationArgs;
 * import com.pulumi.aws.ssm.inputs.AssociationTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Association("example", AssociationArgs.builder()
 *             .scheduleExpression("cron(0 2 ? * SUN *)")
 *             .targets(AssociationTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(aws_instance.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM associations using the `association_id`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/association:Association test-association 10abcdef-0abc-1234-5678-90abcdef123456
 * ```
 *
 */
public class Association internal constructor(
    override val javaResource: com.pulumi.aws.ssm.Association,
) : KotlinCustomResource(javaResource, AssociationMapper) {
    /**
     * By default, when you create a new or update associations, the system runs it immediately and then according to the schedule you specified. Enable this option if you do not want an association to run immediately after you create or update it. This parameter is not supported for rate expressions. Default: `false`.
     */
    public val applyOnlyAtCronInterval: Output<Boolean>?
        get() = javaResource.applyOnlyAtCronInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the SSM association
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the SSM association.
     */
    public val associationId: Output<String>
        get() = javaResource.associationId().applyValue({ args0 -> args0 })

    /**
     * The descriptive name for the association.
     */
    public val associationName: Output<String>?
        get() = javaResource.associationName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify the target for the association. This target is required for associations that use an `Automation` document and target resources by using rate controls. This should be set to the SSM document `parameter` that will define how your automation will branch out.
     */
    public val automationTargetParameterName: Output<String>?
        get() = javaResource.automationTargetParameterName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The compliance severity for the association. Can be one of the following: `UNSPECIFIED`, `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`
     */
    public val complianceSeverity: Output<String>?
        get() = javaResource.complianceSeverity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The document version you want to associate with the target(s). Can be a specific version or the default version.
     */
    public val documentVersion: Output<String>
        get() = javaResource.documentVersion().applyValue({ args0 -> args0 })

    /**
     * The instance ID to apply an SSM document to. Use `targets` with key `InstanceIds` for document schema versions 2.0 and above. Use the `targets` attribute instead.
     */
    @Deprecated(
        message = """
  use 'targets' argument instead.
      https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociation.html#systemsmanager-CreateAssociation-request-InstanceId
  """,
    )
    public val instanceId: Output<String>?
        get() = javaResource.instanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%.
     */
    public val maxConcurrency: Output<String>?
        get() = javaResource.maxConcurrency().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify a number, for example 10, or a percentage of the target set, for example 10%. If you specify a threshold of 3, the stop command is sent when the fourth error is returned. If you specify a threshold of 10% for 50 associations, the stop command is sent when the sixth error is returned.
     */
    public val maxErrors: Output<String>?
        get() = javaResource.maxErrors().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the SSM document to apply.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An output location block. Output Location is documented below.
     */
    public val outputLocation: Output<AssociationOutputLocation>?
        get() = javaResource.outputLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> associationOutputLocationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A block of arbitrary string parameters to pass to the SSM document.
     */
    public val parameters: Output<Map<String, String>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html) that specifies when the association runs.
     */
    public val scheduleExpression: Output<String>?
        get() = javaResource.scheduleExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The mode for generating association compliance. You can specify `AUTO` or `MANUAL`.
     */
    public val syncCompliance: Output<String>?
        get() = javaResource.syncCompliance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A block containing the targets of the SSM association. Targets are documented below. AWS currently supports a maximum of 5 targets.
     */
    public val targets: Output<List<AssociationTarget>>
        get() = javaResource.targets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    associationTargetToKotlin(args0)
                })
            })
        })

    /**
     * The number of seconds to wait for the association status to be `Success`. If `Success` status is not reached within the given time, create opration will fail.
     * Output Location (`output_location`) is an S3 bucket where you want to store the results of this association:
     */
    public val waitForSuccessTimeoutSeconds: Output<Int>?
        get() = javaResource.waitForSuccessTimeoutSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AssociationMapper : ResourceMapper<Association> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.Association::class == javaResource::class

    override fun map(javaResource: Resource): Association = Association(
        javaResource as
            com.pulumi.aws.ssm.Association,
    )
}

/**
 * @see [Association].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Association].
 */
public suspend fun association(name: String, block: suspend AssociationResourceBuilder.() -> Unit):
    Association {
    val builder = AssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Association].
 * @param name The _unique_ name of the resulting resource.
 */
public fun association(name: String): Association {
    val builder = AssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
