@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DefaultPatchBaseline].
 */
@PulumiTagMarker
public class DefaultPatchBaselineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultPatchBaselineArgs = DefaultPatchBaselineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultPatchBaselineArgsBuilder.() -> Unit) {
        val builder = DefaultPatchBaselineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DefaultPatchBaseline {
        val builtJavaResource = com.pulumi.aws.ssm.DefaultPatchBaseline(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DefaultPatchBaseline(builtJavaResource)
    }
}

/**
 * Resource for registering an AWS Systems Manager Default Patch Baseline.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.DefaultPatchBaseline;
 * import com.pulumi.aws.ssm.DefaultPatchBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplePatchBaseline = new PatchBaseline("examplePatchBaseline", PatchBaselineArgs.builder()
 *             .approvedPatches("KB123456")
 *             .build());
 *         var exampleDefaultPatchBaseline = new DefaultPatchBaseline("exampleDefaultPatchBaseline", DefaultPatchBaselineArgs.builder()
 *             .baselineId(examplePatchBaseline.id())
 *             .operatingSystem(examplePatchBaseline.operatingSystem())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using the patch baseline ARN:
 * Using the operating system value:
 * __Using `pulumi import` to import__ the Systems Manager Default Patch Baseline using the patch baseline ID, patch baseline ARN, or the operating system value. For example:
 * Using the patch baseline ID:
 * ```sh
 *  $ pulumi import aws:ssm/defaultPatchBaseline:DefaultPatchBaseline example pb-1234567890abcdef1
 * ```
 *  Using the patch baseline ARN:
 * ```sh
 *  $ pulumi import aws:ssm/defaultPatchBaseline:DefaultPatchBaseline example arn:aws:ssm:us-west-2:123456789012:patchbaseline/pb-1234567890abcdef1
 * ```
 *  Using the operating system value:
 * ```sh
 *  $ pulumi import aws:ssm/defaultPatchBaseline:DefaultPatchBaseline example CENTOS
 * ```
 *
 */
public class DefaultPatchBaseline internal constructor(
    override val javaResource: com.pulumi.aws.ssm.DefaultPatchBaseline,
) : KotlinCustomResource(javaResource, DefaultPatchBaselineMapper) {
    /**
     * ID of the patch baseline.
     * Can be an ID or an ARN.
     * When specifying an AWS-provided patch baseline, must be the ARN.
     */
    public val baselineId: Output<String>
        get() = javaResource.baselineId().applyValue({ args0 -> args0 })

    /**
     * The operating system the patch baseline applies to.
     * Valid values are
     * `AMAZON_LINUX`,
     * `AMAZON_LINUX_2`,
     * `AMAZON_LINUX_2022`,
     * `CENTOS`,
     * `DEBIAN`,
     * `MACOS`,
     * `ORACLE_LINUX`,
     * `RASPBIAN`,
     * `REDHAT_ENTERPRISE_LINUX`,
     * `ROCKY_LINUX`,
     * `SUSE`,
     * `UBUNTU`, and
     * `WINDOWS`.
     */
    public val operatingSystem: Output<String>
        get() = javaResource.operatingSystem().applyValue({ args0 -> args0 })
}

public object DefaultPatchBaselineMapper : ResourceMapper<DefaultPatchBaseline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.DefaultPatchBaseline::class == javaResource::class

    override fun map(javaResource: Resource): DefaultPatchBaseline = DefaultPatchBaseline(
        javaResource
            as com.pulumi.aws.ssm.DefaultPatchBaseline,
    )
}

/**
 * @see [DefaultPatchBaseline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultPatchBaseline].
 */
public suspend fun defaultPatchBaseline(
    name: String,
    block: suspend DefaultPatchBaselineResourceBuilder.() -> Unit,
): DefaultPatchBaseline {
    val builder = DefaultPatchBaselineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultPatchBaseline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultPatchBaseline(name: String): DefaultPatchBaseline {
    val builder = DefaultPatchBaselineResourceBuilder()
    builder.name(name)
    return builder.build()
}
