@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.DefaultPatchBaselineArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for registering an AWS Systems Manager Default Patch Baseline.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.DefaultPatchBaseline;
 * import com.pulumi.aws.ssm.DefaultPatchBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplePatchBaseline = new PatchBaseline("examplePatchBaseline", PatchBaselineArgs.builder()
 *             .approvedPatches("KB123456")
 *             .build());
 *         var exampleDefaultPatchBaseline = new DefaultPatchBaseline("exampleDefaultPatchBaseline", DefaultPatchBaselineArgs.builder()
 *             .baselineId(examplePatchBaseline.id())
 *             .operatingSystem(examplePatchBaseline.operatingSystem())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using the patch baseline ARN:
 * Using the operating system value:
 * __Using `pulumi import` to import__ the Systems Manager Default Patch Baseline using the patch baseline ID, patch baseline ARN, or the operating system value. For example:
 * Using the patch baseline ID:
 * ```sh
 *  $ pulumi import aws:ssm/defaultPatchBaseline:DefaultPatchBaseline example pb-1234567890abcdef1
 * ```
 *  Using the patch baseline ARN:
 * ```sh
 *  $ pulumi import aws:ssm/defaultPatchBaseline:DefaultPatchBaseline example arn:aws:ssm:us-west-2:123456789012:patchbaseline/pb-1234567890abcdef1
 * ```
 *  Using the operating system value:
 * ```sh
 *  $ pulumi import aws:ssm/defaultPatchBaseline:DefaultPatchBaseline example CENTOS
 * ```
 * @property baselineId ID of the patch baseline.
 * Can be an ID or an ARN.
 * When specifying an AWS-provided patch baseline, must be the ARN.
 * @property operatingSystem The operating system the patch baseline applies to.
 * Valid values are
 * `AMAZON_LINUX`,
 * `AMAZON_LINUX_2`,
 * `AMAZON_LINUX_2022`,
 * `CENTOS`,
 * `DEBIAN`,
 * `MACOS`,
 * `ORACLE_LINUX`,
 * `RASPBIAN`,
 * `REDHAT_ENTERPRISE_LINUX`,
 * `ROCKY_LINUX`,
 * `SUSE`,
 * `UBUNTU`, and
 * `WINDOWS`.
 */
public data class DefaultPatchBaselineArgs(
    public val baselineId: Output<String>? = null,
    public val operatingSystem: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.DefaultPatchBaselineArgs> {
    override fun toJava(): com.pulumi.aws.ssm.DefaultPatchBaselineArgs =
        com.pulumi.aws.ssm.DefaultPatchBaselineArgs.builder()
            .baselineId(baselineId?.applyValue({ args0 -> args0 }))
            .operatingSystem(operatingSystem?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultPatchBaselineArgs].
 */
@PulumiTagMarker
public class DefaultPatchBaselineArgsBuilder internal constructor() {
    private var baselineId: Output<String>? = null

    private var operatingSystem: Output<String>? = null

    /**
     * @param value ID of the patch baseline.
     * Can be an ID or an ARN.
     * When specifying an AWS-provided patch baseline, must be the ARN.
     */
    @JvmName("drrnjrnfufxpqxck")
    public suspend fun baselineId(`value`: Output<String>) {
        this.baselineId = value
    }

    /**
     * @param value The operating system the patch baseline applies to.
     * Valid values are
     * `AMAZON_LINUX`,
     * `AMAZON_LINUX_2`,
     * `AMAZON_LINUX_2022`,
     * `CENTOS`,
     * `DEBIAN`,
     * `MACOS`,
     * `ORACLE_LINUX`,
     * `RASPBIAN`,
     * `REDHAT_ENTERPRISE_LINUX`,
     * `ROCKY_LINUX`,
     * `SUSE`,
     * `UBUNTU`, and
     * `WINDOWS`.
     */
    @JvmName("mqopmmmnffvwcpwd")
    public suspend fun operatingSystem(`value`: Output<String>) {
        this.operatingSystem = value
    }

    /**
     * @param value ID of the patch baseline.
     * Can be an ID or an ARN.
     * When specifying an AWS-provided patch baseline, must be the ARN.
     */
    @JvmName("bklejjsjtgqhnxgj")
    public suspend fun baselineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineId = mapped
    }

    /**
     * @param value The operating system the patch baseline applies to.
     * Valid values are
     * `AMAZON_LINUX`,
     * `AMAZON_LINUX_2`,
     * `AMAZON_LINUX_2022`,
     * `CENTOS`,
     * `DEBIAN`,
     * `MACOS`,
     * `ORACLE_LINUX`,
     * `RASPBIAN`,
     * `REDHAT_ENTERPRISE_LINUX`,
     * `ROCKY_LINUX`,
     * `SUSE`,
     * `UBUNTU`, and
     * `WINDOWS`.
     */
    @JvmName("rawjqegfehiucyyo")
    public suspend fun operatingSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingSystem = mapped
    }

    internal fun build(): DefaultPatchBaselineArgs = DefaultPatchBaselineArgs(
        baselineId = baselineId,
        operatingSystem = operatingSystem,
    )
}
