@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.MaintenanceWindowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an SSM Maintenance Window resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindow;
 * import com.pulumi.aws.ssm.MaintenanceWindowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var production = new MaintenanceWindow("production", MaintenanceWindowArgs.builder()
 *             .cutoff(1)
 *             .duration(3)
 *             .schedule("cron(0 16 ? * TUE *)")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM
 * Maintenance Windows using the maintenance window `id`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/maintenanceWindow:MaintenanceWindow imported-window mw-0123456789
 * ```
 * @property allowUnassociatedTargets Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.
 * @property cutoff The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for execution.
 * @property description A description for the maintenance window.
 * @property duration The duration of the Maintenance Window in hours.
 * @property enabled Whether the maintenance window is enabled. Default: `true`.
 * @property endDate Timestamp in [ISO-8601 extended format](https://www.iso.org/iso-8601-date-and-time-format.html) when to no longer run the maintenance window.
 * @property name The name of the maintenance window.
 * @property schedule The schedule of the Maintenance Window in the form of a [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html).
 * @property scheduleOffset The number of days to wait after the date and time specified by a CRON expression before running the maintenance window.
 * @property scheduleTimezone Timezone for schedule in [Internet Assigned Numbers Authority (IANA) Time Zone Database format](https://www.iana.org/time-zones). For example: `America/Los_Angeles`, `etc/UTC`, or `Asia/Seoul`.
 * @property startDate Timestamp in [ISO-8601 extended format](https://www.iso.org/iso-8601-date-and-time-format.html) when to begin the maintenance window.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class MaintenanceWindowArgs(
    public val allowUnassociatedTargets: Output<Boolean>? = null,
    public val cutoff: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val duration: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
    public val endDate: Output<String>? = null,
    public val name: Output<String>? = null,
    public val schedule: Output<String>? = null,
    public val scheduleOffset: Output<Int>? = null,
    public val scheduleTimezone: Output<String>? = null,
    public val startDate: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.MaintenanceWindowArgs> {
    override fun toJava(): com.pulumi.aws.ssm.MaintenanceWindowArgs =
        com.pulumi.aws.ssm.MaintenanceWindowArgs.builder()
            .allowUnassociatedTargets(allowUnassociatedTargets?.applyValue({ args0 -> args0 }))
            .cutoff(cutoff?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0 }))
            .scheduleOffset(scheduleOffset?.applyValue({ args0 -> args0 }))
            .scheduleTimezone(scheduleTimezone?.applyValue({ args0 -> args0 }))
            .startDate(startDate?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MaintenanceWindowArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowArgsBuilder internal constructor() {
    private var allowUnassociatedTargets: Output<Boolean>? = null

    private var cutoff: Output<Int>? = null

    private var description: Output<String>? = null

    private var duration: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    private var endDate: Output<String>? = null

    private var name: Output<String>? = null

    private var schedule: Output<String>? = null

    private var scheduleOffset: Output<Int>? = null

    private var scheduleTimezone: Output<String>? = null

    private var startDate: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.
     */
    @JvmName("svhmmnejcdyyxjcx")
    public suspend fun allowUnassociatedTargets(`value`: Output<Boolean>) {
        this.allowUnassociatedTargets = value
    }

    /**
     * @param value The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for execution.
     */
    @JvmName("vhphtlgbpphkadej")
    public suspend fun cutoff(`value`: Output<Int>) {
        this.cutoff = value
    }

    /**
     * @param value A description for the maintenance window.
     */
    @JvmName("kgrmpbgthyabvdso")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The duration of the Maintenance Window in hours.
     */
    @JvmName("alwtriuxajcsfuor")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value Whether the maintenance window is enabled. Default: `true`.
     */
    @JvmName("grdnqexqvhdgnkqt")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Timestamp in [ISO-8601 extended format](https://www.iso.org/iso-8601-date-and-time-format.html) when to no longer run the maintenance window.
     */
    @JvmName("jaubvankmskmmuqi")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value The name of the maintenance window.
     */
    @JvmName("cfvovnnvvorvsjsu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The schedule of the Maintenance Window in the form of a [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html).
     */
    @JvmName("choaedjjgfpvvtxg")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value The number of days to wait after the date and time specified by a CRON expression before running the maintenance window.
     */
    @JvmName("bncgcvvlyykfaans")
    public suspend fun scheduleOffset(`value`: Output<Int>) {
        this.scheduleOffset = value
    }

    /**
     * @param value Timezone for schedule in [Internet Assigned Numbers Authority (IANA) Time Zone Database format](https://www.iana.org/time-zones). For example: `America/Los_Angeles`, `etc/UTC`, or `Asia/Seoul`.
     */
    @JvmName("rjfnwmemrcfubwta")
    public suspend fun scheduleTimezone(`value`: Output<String>) {
        this.scheduleTimezone = value
    }

    /**
     * @param value Timestamp in [ISO-8601 extended format](https://www.iso.org/iso-8601-date-and-time-format.html) when to begin the maintenance window.
     */
    @JvmName("ebhilcyecheaaovp")
    public suspend fun startDate(`value`: Output<String>) {
        this.startDate = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("knjomollkdwyukoe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.
     */
    @JvmName("uqlsaqothlchclee")
    public suspend fun allowUnassociatedTargets(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowUnassociatedTargets = mapped
    }

    /**
     * @param value The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for execution.
     */
    @JvmName("ipmbumxdskubkedq")
    public suspend fun cutoff(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cutoff = mapped
    }

    /**
     * @param value A description for the maintenance window.
     */
    @JvmName("osuroynxkucrhmuq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The duration of the Maintenance Window in hours.
     */
    @JvmName("poxdbxgsimtqqlwj")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Whether the maintenance window is enabled. Default: `true`.
     */
    @JvmName("hovsseawlkiueqys")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Timestamp in [ISO-8601 extended format](https://www.iso.org/iso-8601-date-and-time-format.html) when to no longer run the maintenance window.
     */
    @JvmName("jmnfqeesvklmnjdy")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value The name of the maintenance window.
     */
    @JvmName("sahspkvxhfygfcqk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The schedule of the Maintenance Window in the form of a [cron or rate expression](https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html).
     */
    @JvmName("ndyewuoqyxtyhqsv")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value The number of days to wait after the date and time specified by a CRON expression before running the maintenance window.
     */
    @JvmName("vubledvhvencbbyd")
    public suspend fun scheduleOffset(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleOffset = mapped
    }

    /**
     * @param value Timezone for schedule in [Internet Assigned Numbers Authority (IANA) Time Zone Database format](https://www.iana.org/time-zones). For example: `America/Los_Angeles`, `etc/UTC`, or `Asia/Seoul`.
     */
    @JvmName("kyjytmuhqetuyuhg")
    public suspend fun scheduleTimezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleTimezone = mapped
    }

    /**
     * @param value Timestamp in [ISO-8601 extended format](https://www.iso.org/iso-8601-date-and-time-format.html) when to begin the maintenance window.
     */
    @JvmName("xsojbnnijrpkbafw")
    public suspend fun startDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDate = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qeenfkumwakqimxn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wjyhedotsdevixmr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MaintenanceWindowArgs = MaintenanceWindowArgs(
        allowUnassociatedTargets = allowUnassociatedTargets,
        cutoff = cutoff,
        description = description,
        duration = duration,
        enabled = enabled,
        endDate = endDate,
        name = name,
        schedule = schedule,
        scheduleOffset = scheduleOffset,
        scheduleTimezone = scheduleTimezone,
        startDate = startDate,
        tags = tags,
    )
}
