@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTargetTarget
import com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTargetTarget.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [MaintenanceWindowTarget].
 */
@PulumiTagMarker
public class MaintenanceWindowTargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MaintenanceWindowTargetArgs = MaintenanceWindowTargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MaintenanceWindowTargetArgsBuilder.() -> Unit) {
        val builder = MaintenanceWindowTargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MaintenanceWindowTarget {
        val builtJavaResource = com.pulumi.aws.ssm.MaintenanceWindowTarget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MaintenanceWindowTarget(builtJavaResource)
    }
}

/**
 * Provides an SSM Maintenance Window Target resource
 * ## Example Usage
 * ### Instance Target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindow;
 * import com.pulumi.aws.ssm.MaintenanceWindowArgs;
 * import com.pulumi.aws.ssm.MaintenanceWindowTarget;
 * import com.pulumi.aws.ssm.MaintenanceWindowTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTargetTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var window = new MaintenanceWindow("window", MaintenanceWindowArgs.builder()
 *             .schedule("cron(0 16 ? * TUE *)")
 *             .duration(3)
 *             .cutoff(1)
 *             .build());
 *         var target1 = new MaintenanceWindowTarget("target1", MaintenanceWindowTargetArgs.builder()
 *             .windowId(window.id())
 *             .description("This is a maintenance window target")
 *             .resourceType("INSTANCE")
 *             .targets(MaintenanceWindowTargetTargetArgs.builder()
 *                 .key("tag:Name")
 *                 .values("acceptance_test")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Resource Group Target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindow;
 * import com.pulumi.aws.ssm.MaintenanceWindowArgs;
 * import com.pulumi.aws.ssm.MaintenanceWindowTarget;
 * import com.pulumi.aws.ssm.MaintenanceWindowTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTargetTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var window = new MaintenanceWindow("window", MaintenanceWindowArgs.builder()
 *             .schedule("cron(0 16 ? * TUE *)")
 *             .duration(3)
 *             .cutoff(1)
 *             .build());
 *         var target1 = new MaintenanceWindowTarget("target1", MaintenanceWindowTargetArgs.builder()
 *             .windowId(window.id())
 *             .description("This is a maintenance window target")
 *             .resourceType("RESOURCE_GROUP")
 *             .targets(MaintenanceWindowTargetTargetArgs.builder()
 *                 .key("resource-groups:ResourceTypeFilters")
 *                 .values("AWS::EC2::Instance")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Maintenance Window targets using `WINDOW_ID/WINDOW_TARGET_ID`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/maintenanceWindowTarget:MaintenanceWindowTarget example mw-0c50858d01EXAMPLE/23639a0b-ddbc-4bca-9e72-78d96EXAMPLE
 * ```
 *
 */
public class MaintenanceWindowTarget internal constructor(
    override val javaResource: com.pulumi.aws.ssm.MaintenanceWindowTarget,
) : KotlinCustomResource(javaResource, MaintenanceWindowTargetMapper) {
    /**
     * The description of the maintenance window target.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the maintenance window target.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * User-provided value that will be included in any CloudWatch events raised while running tasks for these targets in this Maintenance Window.
     */
    public val ownerInformation: Output<String>?
        get() = javaResource.ownerInformation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of target being registered with the Maintenance Window. Possible values are `INSTANCE` and `RESOURCE_GROUP`.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * The targets to register with the maintenance window. In other words, the instances to run commands on when the maintenance window runs. You can specify targets using instance IDs, resource group names, or tags that have been applied to instances. For more information about these examples formats see
     * (https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html)
     */
    public val targets: Output<List<MaintenanceWindowTargetTarget>>
        get() = javaResource.targets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The Id of the maintenance window to register the target with.
     */
    public val windowId: Output<String>
        get() = javaResource.windowId().applyValue({ args0 -> args0 })
}

public object MaintenanceWindowTargetMapper : ResourceMapper<MaintenanceWindowTarget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.MaintenanceWindowTarget::class == javaResource::class

    override fun map(javaResource: Resource): MaintenanceWindowTarget =
        MaintenanceWindowTarget(javaResource as com.pulumi.aws.ssm.MaintenanceWindowTarget)
}

/**
 * @see [MaintenanceWindowTarget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MaintenanceWindowTarget].
 */
public suspend fun maintenanceWindowTarget(
    name: String,
    block: suspend MaintenanceWindowTargetResourceBuilder.() -> Unit,
): MaintenanceWindowTarget {
    val builder = MaintenanceWindowTargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MaintenanceWindowTarget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun maintenanceWindowTarget(name: String): MaintenanceWindowTarget {
    val builder = MaintenanceWindowTargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
