@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.MaintenanceWindowTargetArgs.builder
import com.pulumi.aws.ssm.kotlin.inputs.MaintenanceWindowTargetTargetArgs
import com.pulumi.aws.ssm.kotlin.inputs.MaintenanceWindowTargetTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an SSM Maintenance Window Target resource
 * ## Example Usage
 * ### Instance Target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindow;
 * import com.pulumi.aws.ssm.MaintenanceWindowArgs;
 * import com.pulumi.aws.ssm.MaintenanceWindowTarget;
 * import com.pulumi.aws.ssm.MaintenanceWindowTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTargetTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var window = new MaintenanceWindow("window", MaintenanceWindowArgs.builder()
 *             .schedule("cron(0 16 ? * TUE *)")
 *             .duration(3)
 *             .cutoff(1)
 *             .build());
 *         var target1 = new MaintenanceWindowTarget("target1", MaintenanceWindowTargetArgs.builder()
 *             .windowId(window.id())
 *             .description("This is a maintenance window target")
 *             .resourceType("INSTANCE")
 *             .targets(MaintenanceWindowTargetTargetArgs.builder()
 *                 .key("tag:Name")
 *                 .values("acceptance_test")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Resource Group Target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindow;
 * import com.pulumi.aws.ssm.MaintenanceWindowArgs;
 * import com.pulumi.aws.ssm.MaintenanceWindowTarget;
 * import com.pulumi.aws.ssm.MaintenanceWindowTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTargetTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var window = new MaintenanceWindow("window", MaintenanceWindowArgs.builder()
 *             .schedule("cron(0 16 ? * TUE *)")
 *             .duration(3)
 *             .cutoff(1)
 *             .build());
 *         var target1 = new MaintenanceWindowTarget("target1", MaintenanceWindowTargetArgs.builder()
 *             .windowId(window.id())
 *             .description("This is a maintenance window target")
 *             .resourceType("RESOURCE_GROUP")
 *             .targets(MaintenanceWindowTargetTargetArgs.builder()
 *                 .key("resource-groups:ResourceTypeFilters")
 *                 .values("AWS::EC2::Instance")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Maintenance Window targets using `WINDOW_ID/WINDOW_TARGET_ID`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/maintenanceWindowTarget:MaintenanceWindowTarget example mw-0c50858d01EXAMPLE/23639a0b-ddbc-4bca-9e72-78d96EXAMPLE
 * ```
 * @property description The description of the maintenance window target.
 * @property name The name of the maintenance window target.
 * @property ownerInformation User-provided value that will be included in any CloudWatch events raised while running tasks for these targets in this Maintenance Window.
 * @property resourceType The type of target being registered with the Maintenance Window. Possible values are `INSTANCE` and `RESOURCE_GROUP`.
 * @property targets The targets to register with the maintenance window. In other words, the instances to run commands on when the maintenance window runs. You can specify targets using instance IDs, resource group names, or tags that have been applied to instances. For more information about these examples formats see
 * (https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html)
 * @property windowId The Id of the maintenance window to register the target with.
 */
public data class MaintenanceWindowTargetArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ownerInformation: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val targets: Output<List<MaintenanceWindowTargetTargetArgs>>? = null,
    public val windowId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.MaintenanceWindowTargetArgs> {
    override fun toJava(): com.pulumi.aws.ssm.MaintenanceWindowTargetArgs =
        com.pulumi.aws.ssm.MaintenanceWindowTargetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ownerInformation(ownerInformation?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .windowId(windowId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaintenanceWindowTargetArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowTargetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var ownerInformation: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var targets: Output<List<MaintenanceWindowTargetTargetArgs>>? = null

    private var windowId: Output<String>? = null

    /**
     * @param value The description of the maintenance window target.
     */
    @JvmName("uctltgflsklhwqrt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the maintenance window target.
     */
    @JvmName("xqhetxssdmrkygse")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value User-provided value that will be included in any CloudWatch events raised while running tasks for these targets in this Maintenance Window.
     */
    @JvmName("lbpgjqncdxffetre")
    public suspend fun ownerInformation(`value`: Output<String>) {
        this.ownerInformation = value
    }

    /**
     * @param value The type of target being registered with the Maintenance Window. Possible values are `INSTANCE` and `RESOURCE_GROUP`.
     */
    @JvmName("lbqkhonhikgopppq")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The targets to register with the maintenance window. In other words, the instances to run commands on when the maintenance window runs. You can specify targets using instance IDs, resource group names, or tags that have been applied to instances. For more information about these examples formats see
     * (https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html)
     */
    @JvmName("xmxjppgmfifljunf")
    public suspend fun targets(`value`: Output<List<MaintenanceWindowTargetTargetArgs>>) {
        this.targets = value
    }

    @JvmName("amvjvebgaffasusw")
    public suspend fun targets(vararg values: Output<MaintenanceWindowTargetTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values The targets to register with the maintenance window. In other words, the instances to run commands on when the maintenance window runs. You can specify targets using instance IDs, resource group names, or tags that have been applied to instances. For more information about these examples formats see
     * (https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html)
     */
    @JvmName("ldvomjbfaosjbrwo")
    public suspend fun targets(values: List<Output<MaintenanceWindowTargetTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value The Id of the maintenance window to register the target with.
     */
    @JvmName("rpjwqkscdynccomj")
    public suspend fun windowId(`value`: Output<String>) {
        this.windowId = value
    }

    /**
     * @param value The description of the maintenance window target.
     */
    @JvmName("dxajjfigpacuwpal")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the maintenance window target.
     */
    @JvmName("mwegryxcgebrdggc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value User-provided value that will be included in any CloudWatch events raised while running tasks for these targets in this Maintenance Window.
     */
    @JvmName("plpggqimavmqxtls")
    public suspend fun ownerInformation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerInformation = mapped
    }

    /**
     * @param value The type of target being registered with the Maintenance Window. Possible values are `INSTANCE` and `RESOURCE_GROUP`.
     */
    @JvmName("btpnrithpfysqgdj")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The targets to register with the maintenance window. In other words, the instances to run commands on when the maintenance window runs. You can specify targets using instance IDs, resource group names, or tags that have been applied to instances. For more information about these examples formats see
     * (https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html)
     */
    @JvmName("cfxrpeahlivkfoen")
    public suspend fun targets(`value`: List<MaintenanceWindowTargetTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument The targets to register with the maintenance window. In other words, the instances to run commands on when the maintenance window runs. You can specify targets using instance IDs, resource group names, or tags that have been applied to instances. For more information about these examples formats see
     * (https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html)
     */
    @JvmName("ebsogpwkofejwfdc")
    public suspend
    fun targets(argument: List<suspend MaintenanceWindowTargetTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowTargetTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The targets to register with the maintenance window. In other words, the instances to run commands on when the maintenance window runs. You can specify targets using instance IDs, resource group names, or tags that have been applied to instances. For more information about these examples formats see
     * (https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html)
     */
    @JvmName("dtppwfypmqlsjids")
    public suspend fun targets(
        vararg
        argument: suspend MaintenanceWindowTargetTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowTargetTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The targets to register with the maintenance window. In other words, the instances to run commands on when the maintenance window runs. You can specify targets using instance IDs, resource group names, or tags that have been applied to instances. For more information about these examples formats see
     * (https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html)
     */
    @JvmName("upwdkdgiipoyjsda")
    public suspend
    fun targets(argument: suspend MaintenanceWindowTargetTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MaintenanceWindowTargetTargetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values The targets to register with the maintenance window. In other words, the instances to run commands on when the maintenance window runs. You can specify targets using instance IDs, resource group names, or tags that have been applied to instances. For more information about these examples formats see
     * (https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html)
     */
    @JvmName("uejtbfrpunwkhnhy")
    public suspend fun targets(vararg values: MaintenanceWindowTargetTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param value The Id of the maintenance window to register the target with.
     */
    @JvmName("wjvkchuravnuigdi")
    public suspend fun windowId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowId = mapped
    }

    internal fun build(): MaintenanceWindowTargetArgs = MaintenanceWindowTargetArgs(
        description = description,
        name = name,
        ownerInformation = ownerInformation,
        resourceType = resourceType,
        targets = targets,
        windowId = windowId,
    )
}
