@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTarget
import com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParameters
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTarget.Companion.toKotlin as maintenanceWindowTaskTargetToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParameters.Companion.toKotlin as maintenanceWindowTaskTaskInvocationParametersToKotlin

/**
 * Builder for [MaintenanceWindowTask].
 */
@PulumiTagMarker
public class MaintenanceWindowTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MaintenanceWindowTaskArgs = MaintenanceWindowTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MaintenanceWindowTaskArgsBuilder.() -> Unit) {
        val builder = MaintenanceWindowTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MaintenanceWindowTask {
        val builtJavaResource = com.pulumi.aws.ssm.MaintenanceWindowTask(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MaintenanceWindowTask(builtJavaResource)
    }
}

/**
 * Provides an SSM Maintenance Window Task resource
 * ## Example Usage
 * ### Automation Tasks
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn("AWS-RestartEC2Instance")
 *             .taskType("AUTOMATION")
 *             .windowId(aws_ssm_maintenance_window.example().id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(aws_instance.example().id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .automationParameters(MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs.builder()
 *                     .documentVersion("$LATEST")
 *                     .parameters(MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs.builder()
 *                         .name("InstanceId")
 *                         .values(aws_instance.example().id())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Run Command Tasks
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn("AWS-RunShellScript")
 *             .taskType("RUN_COMMAND")
 *             .windowId(aws_ssm_maintenance_window.example().id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(aws_instance.example().id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .runCommandParameters(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs.builder()
 *                     .outputS3Bucket(aws_s3_bucket.example().id())
 *                     .outputS3KeyPrefix("output")
 *                     .serviceRoleArn(aws_iam_role.example().arn())
 *                     .timeoutSeconds(600)
 *                     .notificationConfig(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs.builder()
 *                         .notificationArn(aws_sns_topic.example().arn())
 *                         .notificationEvents("All")
 *                         .notificationType("Command")
 *                         .build())
 *                     .parameters(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs.builder()
 *                         .name("commands")
 *                         .values("date")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Step Function Tasks
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn(aws_sfn_activity.example().id())
 *             .taskType("STEP_FUNCTIONS")
 *             .windowId(aws_ssm_maintenance_window.example().id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(aws_instance.example().id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .stepFunctionsParameters(MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs.builder()
 *                     .input("{\"key1\":\"value1\"}")
 *                     .name("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Maintenance Window Task using the `window_id` and `window_task_id` separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/maintenanceWindowTask:MaintenanceWindowTask task <window_id>/<window_task_id>
 * ```
 *
 */
public class MaintenanceWindowTask internal constructor(
    override val javaResource: com.pulumi.aws.ssm.MaintenanceWindowTask,
) : KotlinCustomResource(javaResource, MaintenanceWindowTaskMapper) {
    /**
     * The ARN of the maintenance window task.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
     */
    public val cutoffBehavior: Output<String>?
        get() = javaResource.cutoffBehavior().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the maintenance window task.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum number of targets this task can be run for in parallel.
     */
    public val maxConcurrency: Output<String>
        get() = javaResource.maxConcurrency().applyValue({ args0 -> args0 })

    /**
     * The maximum number of errors allowed before this task stops being scheduled.
     */
    public val maxErrors: Output<String>
        get() = javaResource.maxErrors().applyValue({ args0 -> args0 })

    /**
     * The name of the maintenance window task.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
     */
    public val serviceRoleArn: Output<String>
        get() = javaResource.serviceRoleArn().applyValue({ args0 -> args0 })

    /**
     * The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    public val targets: Output<List<MaintenanceWindowTaskTarget>>?
        get() = javaResource.targets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> maintenanceWindowTaskTargetToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The ARN of the task to execute.
     */
    public val taskArn: Output<String>
        get() = javaResource.taskArn().applyValue({ args0 -> args0 })

    /**
     * Configuration block with parameters for task execution.
     */
    public val taskInvocationParameters: Output<MaintenanceWindowTaskTaskInvocationParameters>?
        get() = javaResource.taskInvocationParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    maintenanceWindowTaskTaskInvocationParametersToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
     */
    public val taskType: Output<String>
        get() = javaResource.taskType().applyValue({ args0 -> args0 })

    /**
     * The Id of the maintenance window to register the task with.
     */
    public val windowId: Output<String>
        get() = javaResource.windowId().applyValue({ args0 -> args0 })

    /**
     * The ID of the maintenance window task.
     */
    public val windowTaskId: Output<String>
        get() = javaResource.windowTaskId().applyValue({ args0 -> args0 })
}

public object MaintenanceWindowTaskMapper : ResourceMapper<MaintenanceWindowTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.MaintenanceWindowTask::class == javaResource::class

    override fun map(javaResource: Resource): MaintenanceWindowTask =
        MaintenanceWindowTask(javaResource as com.pulumi.aws.ssm.MaintenanceWindowTask)
}

/**
 * @see [MaintenanceWindowTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MaintenanceWindowTask].
 */
public suspend fun maintenanceWindowTask(
    name: String,
    block: suspend MaintenanceWindowTaskResourceBuilder.() -> Unit,
): MaintenanceWindowTask {
    val builder = MaintenanceWindowTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MaintenanceWindowTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun maintenanceWindowTask(name: String): MaintenanceWindowTask {
    val builder = MaintenanceWindowTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
