@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs.builder
import com.pulumi.aws.ssm.kotlin.inputs.MaintenanceWindowTaskTargetArgs
import com.pulumi.aws.ssm.kotlin.inputs.MaintenanceWindowTaskTargetArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs
import com.pulumi.aws.ssm.kotlin.inputs.MaintenanceWindowTaskTaskInvocationParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an SSM Maintenance Window Task resource
 * ## Example Usage
 * ### Automation Tasks
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn("AWS-RestartEC2Instance")
 *             .taskType("AUTOMATION")
 *             .windowId(aws_ssm_maintenance_window.example().id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(aws_instance.example().id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .automationParameters(MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs.builder()
 *                     .documentVersion("$LATEST")
 *                     .parameters(MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs.builder()
 *                         .name("InstanceId")
 *                         .values(aws_instance.example().id())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Run Command Tasks
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn("AWS-RunShellScript")
 *             .taskType("RUN_COMMAND")
 *             .windowId(aws_ssm_maintenance_window.example().id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(aws_instance.example().id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .runCommandParameters(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs.builder()
 *                     .outputS3Bucket(aws_s3_bucket.example().id())
 *                     .outputS3KeyPrefix("output")
 *                     .serviceRoleArn(aws_iam_role.example().arn())
 *                     .timeoutSeconds(600)
 *                     .notificationConfig(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs.builder()
 *                         .notificationArn(aws_sns_topic.example().arn())
 *                         .notificationEvents("All")
 *                         .notificationType("Command")
 *                         .build())
 *                     .parameters(MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs.builder()
 *                         .name("commands")
 *                         .values("date")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Step Function Tasks
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.MaintenanceWindowTask;
 * import com.pulumi.aws.ssm.MaintenanceWindowTaskArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTargetArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs;
 * import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MaintenanceWindowTask("example", MaintenanceWindowTaskArgs.builder()
 *             .maxConcurrency(2)
 *             .maxErrors(1)
 *             .priority(1)
 *             .taskArn(aws_sfn_activity.example().id())
 *             .taskType("STEP_FUNCTIONS")
 *             .windowId(aws_ssm_maintenance_window.example().id())
 *             .targets(MaintenanceWindowTaskTargetArgs.builder()
 *                 .key("InstanceIds")
 *                 .values(aws_instance.example().id())
 *                 .build())
 *             .taskInvocationParameters(MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
 *                 .stepFunctionsParameters(MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs.builder()
 *                     .input("{\"key1\":\"value1\"}")
 *                     .name("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Maintenance Window Task using the `window_id` and `window_task_id` separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/maintenanceWindowTask:MaintenanceWindowTask task <window_id>/<window_task_id>
 * ```
 * @property cutoffBehavior Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
 * @property description The description of the maintenance window task.
 * @property maxConcurrency The maximum number of targets this task can be run for in parallel.
 * @property maxErrors The maximum number of errors allowed before this task stops being scheduled.
 * @property name The name of the maintenance window task.
 * @property priority The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
 * @property serviceRoleArn The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
 * @property targets The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
 * @property taskArn The ARN of the task to execute.
 * @property taskInvocationParameters Configuration block with parameters for task execution.
 * @property taskType The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
 * @property windowId The Id of the maintenance window to register the task with.
 */
public data class MaintenanceWindowTaskArgs(
    public val cutoffBehavior: Output<String>? = null,
    public val description: Output<String>? = null,
    public val maxConcurrency: Output<String>? = null,
    public val maxErrors: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val serviceRoleArn: Output<String>? = null,
    public val targets: Output<List<MaintenanceWindowTaskTargetArgs>>? = null,
    public val taskArn: Output<String>? = null,
    public val taskInvocationParameters: Output<MaintenanceWindowTaskTaskInvocationParametersArgs>? =
        null,
    public val taskType: Output<String>? = null,
    public val windowId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.MaintenanceWindowTaskArgs> {
    override fun toJava(): com.pulumi.aws.ssm.MaintenanceWindowTaskArgs =
        com.pulumi.aws.ssm.MaintenanceWindowTaskArgs.builder()
            .cutoffBehavior(cutoffBehavior?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .maxConcurrency(maxConcurrency?.applyValue({ args0 -> args0 }))
            .maxErrors(maxErrors?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .serviceRoleArn(serviceRoleArn?.applyValue({ args0 -> args0 }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .taskArn(taskArn?.applyValue({ args0 -> args0 }))
            .taskInvocationParameters(
                taskInvocationParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .taskType(taskType?.applyValue({ args0 -> args0 }))
            .windowId(windowId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaintenanceWindowTaskArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowTaskArgsBuilder internal constructor() {
    private var cutoffBehavior: Output<String>? = null

    private var description: Output<String>? = null

    private var maxConcurrency: Output<String>? = null

    private var maxErrors: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var serviceRoleArn: Output<String>? = null

    private var targets: Output<List<MaintenanceWindowTaskTargetArgs>>? = null

    private var taskArn: Output<String>? = null

    private var taskInvocationParameters: Output<MaintenanceWindowTaskTaskInvocationParametersArgs>? =
        null

    private var taskType: Output<String>? = null

    private var windowId: Output<String>? = null

    /**
     * @param value Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
     */
    @JvmName("awseffchnyhorrnr")
    public suspend fun cutoffBehavior(`value`: Output<String>) {
        this.cutoffBehavior = value
    }

    /**
     * @param value The description of the maintenance window task.
     */
    @JvmName("yuncguxxqjnjqpnc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The maximum number of targets this task can be run for in parallel.
     */
    @JvmName("hanbpwclmkywofww")
    public suspend fun maxConcurrency(`value`: Output<String>) {
        this.maxConcurrency = value
    }

    /**
     * @param value The maximum number of errors allowed before this task stops being scheduled.
     */
    @JvmName("pjujokkdkmpxqkan")
    public suspend fun maxErrors(`value`: Output<String>) {
        this.maxErrors = value
    }

    /**
     * @param value The name of the maintenance window task.
     */
    @JvmName("pnphtvcctpkaqfwc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
     */
    @JvmName("dmcovmbywtpajlum")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
     */
    @JvmName("hptxovworhqqonjg")
    public suspend fun serviceRoleArn(`value`: Output<String>) {
        this.serviceRoleArn = value
    }

    /**
     * @param value The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("dtesqyemxebjfhvj")
    public suspend fun targets(`value`: Output<List<MaintenanceWindowTaskTargetArgs>>) {
        this.targets = value
    }

    @JvmName("dgthrfjorxsnhlsh")
    public suspend fun targets(vararg values: Output<MaintenanceWindowTaskTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("tpmntukarwdocwia")
    public suspend fun targets(values: List<Output<MaintenanceWindowTaskTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value The ARN of the task to execute.
     */
    @JvmName("qrsblxumbxlgtxwe")
    public suspend fun taskArn(`value`: Output<String>) {
        this.taskArn = value
    }

    /**
     * @param value Configuration block with parameters for task execution.
     */
    @JvmName("hajgypabbktaesbn")
    public suspend
    fun taskInvocationParameters(`value`: Output<MaintenanceWindowTaskTaskInvocationParametersArgs>) {
        this.taskInvocationParameters = value
    }

    /**
     * @param value The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
     */
    @JvmName("duptlbosibfrlmgq")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value The Id of the maintenance window to register the task with.
     */
    @JvmName("oetxjxgndqygmsal")
    public suspend fun windowId(`value`: Output<String>) {
        this.windowId = value
    }

    /**
     * @param value Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
     */
    @JvmName("hbsgpyyveqowuuio")
    public suspend fun cutoffBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cutoffBehavior = mapped
    }

    /**
     * @param value The description of the maintenance window task.
     */
    @JvmName("daqvbekdousnhgwp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The maximum number of targets this task can be run for in parallel.
     */
    @JvmName("jpmrfenvddhwrvqn")
    public suspend fun maxConcurrency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrency = mapped
    }

    /**
     * @param value The maximum number of errors allowed before this task stops being scheduled.
     */
    @JvmName("pwmsrcfqtcosmlmk")
    public suspend fun maxErrors(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxErrors = mapped
    }

    /**
     * @param value The name of the maintenance window task.
     */
    @JvmName("opxeaqsnnfmnykgr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
     */
    @JvmName("egenwmrhoeucrbdg")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
     */
    @JvmName("rviwlmreuesdcotl")
    public suspend fun serviceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRoleArn = mapped
    }

    /**
     * @param value The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("ryngkcrgbceaheaa")
    public suspend fun targets(`value`: List<MaintenanceWindowTaskTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("oynuppbqimjvyxtj")
    public suspend
    fun targets(argument: List<suspend MaintenanceWindowTaskTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowTaskTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("klrvbqvdwivcmqac")
    public suspend fun targets(
        vararg
        argument: suspend MaintenanceWindowTaskTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowTaskTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("awnjqtjyxnlextpp")
    public suspend fun targets(argument: suspend MaintenanceWindowTaskTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MaintenanceWindowTaskTargetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
     */
    @JvmName("nktgydijndlgljcw")
    public suspend fun targets(vararg values: MaintenanceWindowTaskTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param value The ARN of the task to execute.
     */
    @JvmName("trniybchmlnihumg")
    public suspend fun taskArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskArn = mapped
    }

    /**
     * @param value Configuration block with parameters for task execution.
     */
    @JvmName("ptvlbxmdvgodtkhj")
    public suspend
    fun taskInvocationParameters(`value`: MaintenanceWindowTaskTaskInvocationParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskInvocationParameters = mapped
    }

    /**
     * @param argument Configuration block with parameters for task execution.
     */
    @JvmName("dmctnrvetftuikfd")
    public suspend
    fun taskInvocationParameters(argument: suspend MaintenanceWindowTaskTaskInvocationParametersArgsBuilder.() -> Unit) {
        val toBeMapped = MaintenanceWindowTaskTaskInvocationParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.taskInvocationParameters = mapped
    }

    /**
     * @param value The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
     */
    @JvmName("scfitwidxgaeoshn")
    public suspend fun taskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    /**
     * @param value The Id of the maintenance window to register the task with.
     */
    @JvmName("advwgyafjyjcpski")
    public suspend fun windowId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowId = mapped
    }

    internal fun build(): MaintenanceWindowTaskArgs = MaintenanceWindowTaskArgs(
        cutoffBehavior = cutoffBehavior,
        description = description,
        maxConcurrency = maxConcurrency,
        maxErrors = maxErrors,
        name = name,
        priority = priority,
        serviceRoleArn = serviceRoleArn,
        targets = targets,
        taskArn = taskArn,
        taskInvocationParameters = taskInvocationParameters,
        taskType = taskType,
        windowId = windowId,
    )
}
