@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Parameter].
 */
@PulumiTagMarker
public class ParameterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ParameterArgs = ParameterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ParameterArgsBuilder.() -> Unit) {
        val builder = ParameterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Parameter {
        val builtJavaResource = com.pulumi.aws.ssm.Parameter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Parameter(builtJavaResource)
    }
}

/**
 * Provides an SSM Parameter resource.
 * > **Note:** `overwrite` also makes it possible to overwrite an existing SSM Parameter that's not created by the provider before. This argument has been deprecated and will be removed in v6.0.0 of the provider. For more information on how this affects the behavior of this resource, see this issue comment.
 * ## Example Usage
 * ### Basic example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Parameter;
 * import com.pulumi.aws.ssm.ParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Parameter("foo", ParameterArgs.builder()
 *             .type("String")
 *             .value("bar")
 *             .build());
 *     }
 * }
 * ```
 * ### Encrypted string using default SSM KMS key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.ssm.Parameter;
 * import com.pulumi.aws.ssm.ParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .storageType("gp2")
 *             .engine("mysql")
 *             .engineVersion("5.7.16")
 *             .instanceClass("db.t2.micro")
 *             .dbName("mydb")
 *             .username("foo")
 *             .password(var_.database_master_password())
 *             .dbSubnetGroupName("my_database_subnet_group")
 *             .parameterGroupName("default.mysql5.7")
 *             .build());
 *         var secret = new Parameter("secret", ParameterArgs.builder()
 *             .description("The parameter description")
 *             .type("SecureString")
 *             .value(var_.database_master_password())
 *             .tags(Map.of("environment", "production"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Parameters using the parameter store `name`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/parameter:Parameter my_param /my_path/my_paramname
 * ```
 *
 */
public class Parameter internal constructor(
    override val javaResource: com.pulumi.aws.ssm.Parameter,
) : KotlinCustomResource(javaResource, ParameterMapper) {
    /**
     * Regular expression used to validate the parameter value.
     */
    public val allowedPattern: Output<String>?
        get() = javaResource.allowedPattern().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the parameter.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Data type of the parameter. Valid values: `text`, `aws:ssm:integration` and `aws:ec2:image` for AMI format, see the [Native parameter support for Amazon Machine Image IDs](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html).
     */
    public val dataType: Output<String>
        get() = javaResource.dataType().applyValue({ args0 -> args0 })

    /**
     * Description of the parameter.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Value of the parameter. **Use caution:** This value is _never_ marked as sensitive in the pulumi preview output. This argument is not valid with a `type` of `SecureString`.
     */
    public val insecureValue: Output<String>
        get() = javaResource.insecureValue().applyValue({ args0 -> args0 })

    /**
     * KMS key ID or ARN for encrypting a SecureString.
     */
    public val keyId: Output<String>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * Name of the parameter. If the name contains a path (e.g., any forward slashes (`/`)), it must be fully qualified with a leading forward slash (`/`). For additional requirements and constraints, see the [AWS SSM User Guide](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html).
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Overwrite an existing parameter. If not specified, defaults to `false` if the resource has not been created by Pulumi to avoid overwrite of existing resource, and will default to `true` otherwise (Pulumi lifecycle rules should then be used to manage the update behavior).
     */
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    public val overwrite: Output<Boolean>?
        get() = javaResource.overwrite().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Parameter tier to assign to the parameter. If not specified, will use the default parameter tier for the region. Valid tiers are `Standard`, `Advanced`, and `Intelligent-Tiering`. Downgrading an `Advanced` tier parameter to `Standard` will recreate the resource. For more information on parameter tiers, see the [AWS SSM Parameter tier comparison and guide](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html).
     */
    public val tier: Output<String>?
        get() = javaResource.tier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Type of the parameter. Valid types are `String`, `StringList` and `SecureString`.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Value of the parameter. This value is always marked as sensitive in the pulumi preview output, regardless of `type`.
     * > **NOTE:** `aws:ssm:integration` data_type parameters must be of the type `SecureString` and the name must start with the prefix `/d9d01087-4a3f-49e0-b0b4-d568d7826553/ssm/integrations/webhook/`. See [here](https://docs.aws.amazon.com/systems-manager/latest/userguide/creating-integrations.html) for information on the usage of `aws:ssm:integration` parameters.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })

    /**
     * Version of the parameter.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object ParameterMapper : ResourceMapper<Parameter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.Parameter::class == javaResource::class

    override fun map(javaResource: Resource): Parameter = Parameter(
        javaResource as
            com.pulumi.aws.ssm.Parameter,
    )
}

/**
 * @see [Parameter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Parameter].
 */
public suspend fun parameter(name: String, block: suspend ParameterResourceBuilder.() -> Unit):
    Parameter {
    val builder = ParameterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Parameter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun parameter(name: String): Parameter {
    val builder = ParameterResourceBuilder()
    builder.name(name)
    return builder.build()
}
