@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.ParameterArgs.builder
import com.pulumi.aws.ssm.kotlin.enums.ParameterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an SSM Parameter resource.
 * > **Note:** `overwrite` also makes it possible to overwrite an existing SSM Parameter that's not created by the provider before. This argument has been deprecated and will be removed in v6.0.0 of the provider. For more information on how this affects the behavior of this resource, see this issue comment.
 * ## Example Usage
 * ### Basic example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.Parameter;
 * import com.pulumi.aws.ssm.ParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Parameter("foo", ParameterArgs.builder()
 *             .type("String")
 *             .value("bar")
 *             .build());
 *     }
 * }
 * ```
 * ### Encrypted string using default SSM KMS key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.ssm.Parameter;
 * import com.pulumi.aws.ssm.ParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .storageType("gp2")
 *             .engine("mysql")
 *             .engineVersion("5.7.16")
 *             .instanceClass("db.t2.micro")
 *             .dbName("mydb")
 *             .username("foo")
 *             .password(var_.database_master_password())
 *             .dbSubnetGroupName("my_database_subnet_group")
 *             .parameterGroupName("default.mysql5.7")
 *             .build());
 *         var secret = new Parameter("secret", ParameterArgs.builder()
 *             .description("The parameter description")
 *             .type("SecureString")
 *             .value(var_.database_master_password())
 *             .tags(Map.of("environment", "production"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Parameters using the parameter store `name`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/parameter:Parameter my_param /my_path/my_paramname
 * ```
 * @property allowedPattern Regular expression used to validate the parameter value.
 * @property arn ARN of the parameter.
 * @property dataType Data type of the parameter. Valid values: `text`, `aws:ssm:integration` and `aws:ec2:image` for AMI format, see the [Native parameter support for Amazon Machine Image IDs](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html).
 * @property description Description of the parameter.
 * @property insecureValue Value of the parameter. **Use caution:** This value is _never_ marked as sensitive in the pulumi preview output. This argument is not valid with a `type` of `SecureString`.
 * @property keyId KMS key ID or ARN for encrypting a SecureString.
 * @property name Name of the parameter. If the name contains a path (e.g., any forward slashes (`/`)), it must be fully qualified with a leading forward slash (`/`). For additional requirements and constraints, see the [AWS SSM User Guide](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html).
 * @property overwrite Overwrite an existing parameter. If not specified, defaults to `false` if the resource has not been created by Pulumi to avoid overwrite of existing resource, and will default to `true` otherwise (Pulumi lifecycle rules should then be used to manage the update behavior).
 * @property tags Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tier Parameter tier to assign to the parameter. If not specified, will use the default parameter tier for the region. Valid tiers are `Standard`, `Advanced`, and `Intelligent-Tiering`. Downgrading an `Advanced` tier parameter to `Standard` will recreate the resource. For more information on parameter tiers, see the [AWS SSM Parameter tier comparison and guide](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html).
 * @property type Type of the parameter. Valid types are `String`, `StringList` and `SecureString`.
 * The following arguments are optional:
 * @property value Value of the parameter. This value is always marked as sensitive in the pulumi preview output, regardless of `type`.
 * > **NOTE:** `aws:ssm:integration` data_type parameters must be of the type `SecureString` and the name must start with the prefix `/d9d01087-4a3f-49e0-b0b4-d568d7826553/ssm/integrations/webhook/`. See [here](https://docs.aws.amazon.com/systems-manager/latest/userguide/creating-integrations.html) for information on the usage of `aws:ssm:integration` parameters.
 */
public data class ParameterArgs(
    public val allowedPattern: Output<String>? = null,
    public val arn: Output<String>? = null,
    public val dataType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val insecureValue: Output<String>? = null,
    public val keyId: Output<String>? = null,
    public val name: Output<String>? = null,
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    public val overwrite: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tier: Output<String>? = null,
    public val type: Output<Either<String, ParameterType>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.ParameterArgs> {
    override fun toJava(): com.pulumi.aws.ssm.ParameterArgs =
        com.pulumi.aws.ssm.ParameterArgs.builder()
            .allowedPattern(allowedPattern?.applyValue({ args0 -> args0 }))
            .arn(arn?.applyValue({ args0 -> args0 }))
            .dataType(dataType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .insecureValue(insecureValue?.applyValue({ args0 -> args0 }))
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .overwrite(overwrite?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tier(tier?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParameterArgs].
 */
@PulumiTagMarker
public class ParameterArgsBuilder internal constructor() {
    private var allowedPattern: Output<String>? = null

    private var arn: Output<String>? = null

    private var dataType: Output<String>? = null

    private var description: Output<String>? = null

    private var insecureValue: Output<String>? = null

    private var keyId: Output<String>? = null

    private var name: Output<String>? = null

    private var overwrite: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tier: Output<String>? = null

    private var type: Output<Either<String, ParameterType>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Regular expression used to validate the parameter value.
     */
    @JvmName("tlsncgfskhijptnr")
    public suspend fun allowedPattern(`value`: Output<String>) {
        this.allowedPattern = value
    }

    /**
     * @param value ARN of the parameter.
     */
    @JvmName("rxwlqjkmtvuavcga")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Data type of the parameter. Valid values: `text`, `aws:ssm:integration` and `aws:ec2:image` for AMI format, see the [Native parameter support for Amazon Machine Image IDs](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html).
     */
    @JvmName("nmwbhrtrqwlnekyc")
    public suspend fun dataType(`value`: Output<String>) {
        this.dataType = value
    }

    /**
     * @param value Description of the parameter.
     */
    @JvmName("yjqaqqydwdnfbqxs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Value of the parameter. **Use caution:** This value is _never_ marked as sensitive in the pulumi preview output. This argument is not valid with a `type` of `SecureString`.
     */
    @JvmName("ohdtjtuioafktadc")
    public suspend fun insecureValue(`value`: Output<String>) {
        this.insecureValue = value
    }

    /**
     * @param value KMS key ID or ARN for encrypting a SecureString.
     */
    @JvmName("ngxdjnncdbdttavg")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value Name of the parameter. If the name contains a path (e.g., any forward slashes (`/`)), it must be fully qualified with a leading forward slash (`/`). For additional requirements and constraints, see the [AWS SSM User Guide](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html).
     */
    @JvmName("wqwtpkmxujeckmmn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Overwrite an existing parameter. If not specified, defaults to `false` if the resource has not been created by Pulumi to avoid overwrite of existing resource, and will default to `true` otherwise (Pulumi lifecycle rules should then be used to manage the update behavior).
     */
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    @JvmName("mfphwagtvxexkwxa")
    public suspend fun overwrite(`value`: Output<Boolean>) {
        this.overwrite = value
    }

    /**
     * @param value Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ordfqgclbqgsraqd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Parameter tier to assign to the parameter. If not specified, will use the default parameter tier for the region. Valid tiers are `Standard`, `Advanced`, and `Intelligent-Tiering`. Downgrading an `Advanced` tier parameter to `Standard` will recreate the resource. For more information on parameter tiers, see the [AWS SSM Parameter tier comparison and guide](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html).
     */
    @JvmName("pxuuvgjqsaodnylc")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Type of the parameter. Valid types are `String`, `StringList` and `SecureString`.
     * The following arguments are optional:
     */
    @JvmName("gicevxmjipgfqoym")
    public suspend fun type(`value`: Output<Either<String, ParameterType>>) {
        this.type = value
    }

    /**
     * @param value Value of the parameter. This value is always marked as sensitive in the pulumi preview output, regardless of `type`.
     * > **NOTE:** `aws:ssm:integration` data_type parameters must be of the type `SecureString` and the name must start with the prefix `/d9d01087-4a3f-49e0-b0b4-d568d7826553/ssm/integrations/webhook/`. See [here](https://docs.aws.amazon.com/systems-manager/latest/userguide/creating-integrations.html) for information on the usage of `aws:ssm:integration` parameters.
     */
    @JvmName("dhkjhebrdtpacspy")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Regular expression used to validate the parameter value.
     */
    @JvmName("vemnqdfjcdrlcrjw")
    public suspend fun allowedPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedPattern = mapped
    }

    /**
     * @param value ARN of the parameter.
     */
    @JvmName("malwmbbvchftspos")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Data type of the parameter. Valid values: `text`, `aws:ssm:integration` and `aws:ec2:image` for AMI format, see the [Native parameter support for Amazon Machine Image IDs](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html).
     */
    @JvmName("qudoenplleunwbvy")
    public suspend fun dataType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value Description of the parameter.
     */
    @JvmName("otnkvpfbsjgxiekc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Value of the parameter. **Use caution:** This value is _never_ marked as sensitive in the pulumi preview output. This argument is not valid with a `type` of `SecureString`.
     */
    @JvmName("ivcjqovnopnyuenn")
    public suspend fun insecureValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insecureValue = mapped
    }

    /**
     * @param value KMS key ID or ARN for encrypting a SecureString.
     */
    @JvmName("hjavidcqwspcknla")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value Name of the parameter. If the name contains a path (e.g., any forward slashes (`/`)), it must be fully qualified with a leading forward slash (`/`). For additional requirements and constraints, see the [AWS SSM User Guide](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html).
     */
    @JvmName("jvyscbnlbjutfcxw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Overwrite an existing parameter. If not specified, defaults to `false` if the resource has not been created by Pulumi to avoid overwrite of existing resource, and will default to `true` otherwise (Pulumi lifecycle rules should then be used to manage the update behavior).
     */
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    @JvmName("uotcgwmpnvuwxxud")
    public suspend fun overwrite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overwrite = mapped
    }

    /**
     * @param value Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qeucsstuiomquuvj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cjlubcfotsimvhhm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Parameter tier to assign to the parameter. If not specified, will use the default parameter tier for the region. Valid tiers are `Standard`, `Advanced`, and `Intelligent-Tiering`. Downgrading an `Advanced` tier parameter to `Standard` will recreate the resource. For more information on parameter tiers, see the [AWS SSM Parameter tier comparison and guide](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html).
     */
    @JvmName("bkrttohtetmjgwqe")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Type of the parameter. Valid types are `String`, `StringList` and `SecureString`.
     * The following arguments are optional:
     */
    @JvmName("minpyaedbqixiqgw")
    public suspend fun type(`value`: Either<String, ParameterType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the parameter. Valid types are `String`, `StringList` and `SecureString`.
     * The following arguments are optional:
     */
    @JvmName("befswlqjyqonfyqn")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the parameter. Valid types are `String`, `StringList` and `SecureString`.
     * The following arguments are optional:
     */
    @JvmName("waabwtugwuqwrxsi")
    public fun type(`value`: ParameterType) {
        val toBeMapped = Either.ofRight<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Value of the parameter. This value is always marked as sensitive in the pulumi preview output, regardless of `type`.
     * > **NOTE:** `aws:ssm:integration` data_type parameters must be of the type `SecureString` and the name must start with the prefix `/d9d01087-4a3f-49e0-b0b4-d568d7826553/ssm/integrations/webhook/`. See [here](https://docs.aws.amazon.com/systems-manager/latest/userguide/creating-integrations.html) for information on the usage of `aws:ssm:integration` parameters.
     */
    @JvmName("sonreukqkubgmqav")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ParameterArgs = ParameterArgs(
        allowedPattern = allowedPattern,
        arn = arn,
        dataType = dataType,
        description = description,
        insecureValue = insecureValue,
        keyId = keyId,
        name = name,
        overwrite = overwrite,
        tags = tags,
        tier = tier,
        type = type,
        `value` = `value`,
    )
}
