@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineApprovalRule
import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineGlobalFilter
import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineSource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineApprovalRule.Companion.toKotlin as patchBaselineApprovalRuleToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineGlobalFilter.Companion.toKotlin as patchBaselineGlobalFilterToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineSource.Companion.toKotlin as patchBaselineSourceToKotlin

/**
 * Builder for [PatchBaseline].
 */
@PulumiTagMarker
public class PatchBaselineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PatchBaselineArgs = PatchBaselineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PatchBaselineArgsBuilder.() -> Unit) {
        val builder = PatchBaselineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PatchBaseline {
        val builtJavaResource = com.pulumi.aws.ssm.PatchBaseline(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PatchBaseline(builtJavaResource)
    }
}

/**
 * Provides an SSM Patch Baseline resource.
 * > **NOTE on Patch Baselines:** The `approved_patches` and `approval_rule` are
 * both marked as optional fields, but the Patch Baseline requires that at least one
 * of them is specified.
 * ## Example Usage
 * ### Basic Usage
 * Using `approved_patches` only.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var production = new PatchBaseline("production", PatchBaselineArgs.builder()
 *             .approvedPatches("KB123456")
 *             .build());
 *     }
 * }
 * ```
 * ### Advanced Usage, specifying patch filters
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineGlobalFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var production = new PatchBaseline("production", PatchBaselineArgs.builder()
 *             .approvalRules(
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .complianceLevel("HIGH")
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PRODUCT")
 *                             .values("WindowsServer2016")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("CLASSIFICATION")
 *                             .values(
 *                                 "CriticalUpdates",
 *                                 "SecurityUpdates",
 *                                 "Updates")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("MSRC_SEVERITY")
 *                             .values(
 *                                 "Critical",
 *                                 "Important",
 *                                 "Moderate")
 *                             .build())
 *                     .build(),
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                         .key("PRODUCT")
 *                         .values("WindowsServer2012")
 *                         .build())
 *                     .build())
 *             .approvedPatches(
 *                 "KB123456",
 *                 "KB456789")
 *             .description("Patch Baseline Description")
 *             .globalFilters(
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("PRODUCT")
 *                     .values("WindowsServer2008")
 *                     .build(),
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("CLASSIFICATION")
 *                     .values("ServicePacks")
 *                     .build(),
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("MSRC_SEVERITY")
 *                     .values("Low")
 *                     .build())
 *             .rejectedPatches("KB987654")
 *             .build());
 *     }
 * }
 * ```
 * ### Advanced usage, specifying Microsoft application and Windows patch rules
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var windowsOsApps = new PatchBaseline("windowsOsApps", PatchBaselineArgs.builder()
 *             .approvalRules(
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("CLASSIFICATION")
 *                             .values(
 *                                 "CriticalUpdates",
 *                                 "SecurityUpdates")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("MSRC_SEVERITY")
 *                             .values(
 *                                 "Critical",
 *                                 "Important")
 *                             .build())
 *                     .build(),
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PATCH_SET")
 *                             .values("APPLICATION")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PRODUCT")
 *                             .values(
 *                                 "Office 2013",
 *                                 "Office 2016")
 *                             .build())
 *                     .build())
 *             .description("Patch both Windows and Microsoft apps")
 *             .operatingSystem("WINDOWS")
 *             .build());
 *     }
 * }
 * ```
 * ### Advanced usage, specifying alternate patch source repository
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var al201709 = new PatchBaseline("al201709", PatchBaselineArgs.builder()
 *             .approvalRules()
 *             .description("My patch repository for Amazon Linux 2017.09")
 *             .operatingSystem("AMAZON_LINUX")
 *             .sources(PatchBaselineSourceArgs.builder()
 *                 .configuration("""
 * [amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 *                 """)
 *                 .name("My-AL2017.09")
 *                 .products("AmazonLinux2017.09")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Patch Baselines using their baseline ID. For example:
 * ```sh
 *  $ pulumi import aws:ssm/patchBaseline:PatchBaseline example pb-12345678
 * ```
 *
 */
public class PatchBaseline internal constructor(
    override val javaResource: com.pulumi.aws.ssm.PatchBaseline,
) : KotlinCustomResource(javaResource, PatchBaselineMapper) {
    /**
     * A set of rules used to include patches in the baseline.
     * Up to 10 approval rules can be specified.
     * See `approval_rule` below.
     */
    public val approvalRules: Output<List<PatchBaselineApprovalRule>>?
        get() = javaResource.approvalRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        patchBaselineApprovalRuleToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A list of explicitly approved patches for the baseline.
     * Cannot be specified with `approval_rule`.
     */
    public val approvedPatches: Output<List<String>>?
        get() = javaResource.approvedPatches().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The compliance level for approved patches.
     * This means that if an approved patch is reported as missing, this is the severity of the compliance violation.
     * Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, `UNSPECIFIED`.
     * The default value is `UNSPECIFIED`.
     */
    public val approvedPatchesComplianceLevel: Output<String>?
        get() = javaResource.approvedPatchesComplianceLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the list of approved patches includes non-security updates that should be applied to the instances.
     * Applies to Linux instances only.
     */
    public val approvedPatchesEnableNonSecurity: Output<Boolean>?
        get() = javaResource.approvedPatchesEnableNonSecurity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the patch baseline.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the patch baseline.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A set of global filters used to exclude patches from the baseline.
     * Up to 4 global filters can be specified using Key/Value pairs.
     * Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    public val globalFilters: Output<List<PatchBaselineGlobalFilter>>?
        get() = javaResource.globalFilters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        patchBaselineGlobalFilterToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the patch baseline.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The operating system the patch baseline applies to.
     * Valid values are
     * `ALMA_LINUX`,
     * `AMAZON_LINUX`,
     * `AMAZON_LINUX_2`,
     * `AMAZON_LINUX_2022`,
     * `AMAZON_LINUX_2023`,
     * `CENTOS`,
     * `DEBIAN`,
     * `MACOS`,
     * `ORACLE_LINUX`,
     * `RASPBIAN`,
     * `REDHAT_ENTERPRISE_LINUX`,
     * `ROCKY_LINUX`,
     * `SUSE`,
     * `UBUNTU`, and
     * `WINDOWS`.
     * The default value is `WINDOWS`.
     */
    public val operatingSystem: Output<String>?
        get() = javaResource.operatingSystem().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of rejected patches.
     */
    public val rejectedPatches: Output<List<String>>?
        get() = javaResource.rejectedPatches().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The action for Patch Manager to take on patches included in the `rejected_patches` list.
     * Valid values are `ALLOW_AS_DEPENDENCY` and `BLOCK`.
     */
    public val rejectedPatchesAction: Output<String>
        get() = javaResource.rejectedPatchesAction().applyValue({ args0 -> args0 })

    /**
     * Configuration block with alternate sources for patches.
     * Applies to Linux instances only.
     * See `source` below.
     */
    public val sources: Output<List<PatchBaselineSource>>?
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> patchBaselineSourceToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object PatchBaselineMapper : ResourceMapper<PatchBaseline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.PatchBaseline::class == javaResource::class

    override fun map(javaResource: Resource): PatchBaseline = PatchBaseline(
        javaResource as
            com.pulumi.aws.ssm.PatchBaseline,
    )
}

/**
 * @see [PatchBaseline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PatchBaseline].
 */
public suspend fun patchBaseline(
    name: String,
    block: suspend PatchBaselineResourceBuilder.() -> Unit,
): PatchBaseline {
    val builder = PatchBaselineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PatchBaseline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun patchBaseline(name: String): PatchBaseline {
    val builder = PatchBaselineResourceBuilder()
    builder.name(name)
    return builder.build()
}
