@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.PatchBaselineArgs.builder
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineApprovalRuleArgs
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineApprovalRuleArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineGlobalFilterArgs
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineGlobalFilterArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineSourceArgs
import com.pulumi.aws.ssm.kotlin.inputs.PatchBaselineSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an SSM Patch Baseline resource.
 * > **NOTE on Patch Baselines:** The `approved_patches` and `approval_rule` are
 * both marked as optional fields, but the Patch Baseline requires that at least one
 * of them is specified.
 * ## Example Usage
 * ### Basic Usage
 * Using `approved_patches` only.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var production = new PatchBaseline("production", PatchBaselineArgs.builder()
 *             .approvedPatches("KB123456")
 *             .build());
 *     }
 * }
 * ```
 * ### Advanced Usage, specifying patch filters
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineGlobalFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var production = new PatchBaseline("production", PatchBaselineArgs.builder()
 *             .approvalRules(
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .complianceLevel("HIGH")
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PRODUCT")
 *                             .values("WindowsServer2016")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("CLASSIFICATION")
 *                             .values(
 *                                 "CriticalUpdates",
 *                                 "SecurityUpdates",
 *                                 "Updates")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("MSRC_SEVERITY")
 *                             .values(
 *                                 "Critical",
 *                                 "Important",
 *                                 "Moderate")
 *                             .build())
 *                     .build(),
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                         .key("PRODUCT")
 *                         .values("WindowsServer2012")
 *                         .build())
 *                     .build())
 *             .approvedPatches(
 *                 "KB123456",
 *                 "KB456789")
 *             .description("Patch Baseline Description")
 *             .globalFilters(
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("PRODUCT")
 *                     .values("WindowsServer2008")
 *                     .build(),
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("CLASSIFICATION")
 *                     .values("ServicePacks")
 *                     .build(),
 *                 PatchBaselineGlobalFilterArgs.builder()
 *                     .key("MSRC_SEVERITY")
 *                     .values("Low")
 *                     .build())
 *             .rejectedPatches("KB987654")
 *             .build());
 *     }
 * }
 * ```
 * ### Advanced usage, specifying Microsoft application and Windows patch rules
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var windowsOsApps = new PatchBaseline("windowsOsApps", PatchBaselineArgs.builder()
 *             .approvalRules(
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("CLASSIFICATION")
 *                             .values(
 *                                 "CriticalUpdates",
 *                                 "SecurityUpdates")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("MSRC_SEVERITY")
 *                             .values(
 *                                 "Critical",
 *                                 "Important")
 *                             .build())
 *                     .build(),
 *                 PatchBaselineApprovalRuleArgs.builder()
 *                     .approveAfterDays(7)
 *                     .patchFilters(
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PATCH_SET")
 *                             .values("APPLICATION")
 *                             .build(),
 *                         PatchBaselineApprovalRulePatchFilterArgs.builder()
 *                             .key("PRODUCT")
 *                             .values(
 *                                 "Office 2013",
 *                                 "Office 2016")
 *                             .build())
 *                     .build())
 *             .description("Patch both Windows and Microsoft apps")
 *             .operatingSystem("WINDOWS")
 *             .build());
 *     }
 * }
 * ```
 * ### Advanced usage, specifying alternate patch source repository
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs;
 * import com.pulumi.aws.ssm.inputs.PatchBaselineSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var al201709 = new PatchBaseline("al201709", PatchBaselineArgs.builder()
 *             .approvalRules()
 *             .description("My patch repository for Amazon Linux 2017.09")
 *             .operatingSystem("AMAZON_LINUX")
 *             .sources(PatchBaselineSourceArgs.builder()
 *                 .configuration("""
 * [amzn-main]
 * name=amzn-main-Base
 * mirrorlist=http://repo./$awsregion./$awsdomain//$releasever/main/mirror.list
 * mirrorlist_expire=300
 * metadata_expire=300
 * priority=10
 * failovermethod=priority
 * fastestmirror_enabled=0
 * gpgcheck=1
 * gpgkey=file:///etc/pki/rpm-gpg/RPM-GPG-KEY-amazon-ga
 * enabled=1
 * retries=3
 * timeout=5
 * report_instanceid=yes
 *                 """)
 *                 .name("My-AL2017.09")
 *                 .products("AmazonLinux2017.09")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Patch Baselines using their baseline ID. For example:
 * ```sh
 *  $ pulumi import aws:ssm/patchBaseline:PatchBaseline example pb-12345678
 * ```
 * @property approvalRules A set of rules used to include patches in the baseline.
 * Up to 10 approval rules can be specified.
 * See `approval_rule` below.
 * @property approvedPatches A list of explicitly approved patches for the baseline.
 * Cannot be specified with `approval_rule`.
 * @property approvedPatchesComplianceLevel The compliance level for approved patches.
 * This means that if an approved patch is reported as missing, this is the severity of the compliance violation.
 * Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, `UNSPECIFIED`.
 * The default value is `UNSPECIFIED`.
 * @property approvedPatchesEnableNonSecurity Indicates whether the list of approved patches includes non-security updates that should be applied to the instances.
 * Applies to Linux instances only.
 * @property description The description of the patch baseline.
 * @property globalFilters A set of global filters used to exclude patches from the baseline.
 * Up to 4 global filters can be specified using Key/Value pairs.
 * Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
 * @property name The name of the patch baseline.
 * @property operatingSystem The operating system the patch baseline applies to.
 * Valid values are
 * `ALMA_LINUX`,
 * `AMAZON_LINUX`,
 * `AMAZON_LINUX_2`,
 * `AMAZON_LINUX_2022`,
 * `AMAZON_LINUX_2023`,
 * `CENTOS`,
 * `DEBIAN`,
 * `MACOS`,
 * `ORACLE_LINUX`,
 * `RASPBIAN`,
 * `REDHAT_ENTERPRISE_LINUX`,
 * `ROCKY_LINUX`,
 * `SUSE`,
 * `UBUNTU`, and
 * `WINDOWS`.
 * The default value is `WINDOWS`.
 * @property rejectedPatches A list of rejected patches.
 * @property rejectedPatchesAction The action for Patch Manager to take on patches included in the `rejected_patches` list.
 * Valid values are `ALLOW_AS_DEPENDENCY` and `BLOCK`.
 * @property sources Configuration block with alternate sources for patches.
 * Applies to Linux instances only.
 * See `source` below.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PatchBaselineArgs(
    public val approvalRules: Output<List<PatchBaselineApprovalRuleArgs>>? = null,
    public val approvedPatches: Output<List<String>>? = null,
    public val approvedPatchesComplianceLevel: Output<String>? = null,
    public val approvedPatchesEnableNonSecurity: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val globalFilters: Output<List<PatchBaselineGlobalFilterArgs>>? = null,
    public val name: Output<String>? = null,
    public val operatingSystem: Output<String>? = null,
    public val rejectedPatches: Output<List<String>>? = null,
    public val rejectedPatchesAction: Output<String>? = null,
    public val sources: Output<List<PatchBaselineSourceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.PatchBaselineArgs> {
    override fun toJava(): com.pulumi.aws.ssm.PatchBaselineArgs =
        com.pulumi.aws.ssm.PatchBaselineArgs.builder()
            .approvalRules(
                approvalRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .approvedPatches(approvedPatches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .approvedPatchesComplianceLevel(approvedPatchesComplianceLevel?.applyValue({ args0 -> args0 }))
            .approvedPatchesEnableNonSecurity(approvedPatchesEnableNonSecurity?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .globalFilters(
                globalFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .operatingSystem(operatingSystem?.applyValue({ args0 -> args0 }))
            .rejectedPatches(rejectedPatches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .rejectedPatchesAction(rejectedPatchesAction?.applyValue({ args0 -> args0 }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PatchBaselineArgs].
 */
@PulumiTagMarker
public class PatchBaselineArgsBuilder internal constructor() {
    private var approvalRules: Output<List<PatchBaselineApprovalRuleArgs>>? = null

    private var approvedPatches: Output<List<String>>? = null

    private var approvedPatchesComplianceLevel: Output<String>? = null

    private var approvedPatchesEnableNonSecurity: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var globalFilters: Output<List<PatchBaselineGlobalFilterArgs>>? = null

    private var name: Output<String>? = null

    private var operatingSystem: Output<String>? = null

    private var rejectedPatches: Output<List<String>>? = null

    private var rejectedPatchesAction: Output<String>? = null

    private var sources: Output<List<PatchBaselineSourceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A set of rules used to include patches in the baseline.
     * Up to 10 approval rules can be specified.
     * See `approval_rule` below.
     */
    @JvmName("tpecjayijerbgiib")
    public suspend fun approvalRules(`value`: Output<List<PatchBaselineApprovalRuleArgs>>) {
        this.approvalRules = value
    }

    @JvmName("hskfjfstrqftynyb")
    public suspend fun approvalRules(vararg values: Output<PatchBaselineApprovalRuleArgs>) {
        this.approvalRules = Output.all(values.asList())
    }

    /**
     * @param values A set of rules used to include patches in the baseline.
     * Up to 10 approval rules can be specified.
     * See `approval_rule` below.
     */
    @JvmName("rgfatnyptrruucmb")
    public suspend fun approvalRules(values: List<Output<PatchBaselineApprovalRuleArgs>>) {
        this.approvalRules = Output.all(values)
    }

    /**
     * @param value A list of explicitly approved patches for the baseline.
     * Cannot be specified with `approval_rule`.
     */
    @JvmName("ntmphsbjcglepskm")
    public suspend fun approvedPatches(`value`: Output<List<String>>) {
        this.approvedPatches = value
    }

    @JvmName("killpbjucpkbrrsn")
    public suspend fun approvedPatches(vararg values: Output<String>) {
        this.approvedPatches = Output.all(values.asList())
    }

    /**
     * @param values A list of explicitly approved patches for the baseline.
     * Cannot be specified with `approval_rule`.
     */
    @JvmName("qwfjihcgipfjphir")
    public suspend fun approvedPatches(values: List<Output<String>>) {
        this.approvedPatches = Output.all(values)
    }

    /**
     * @param value The compliance level for approved patches.
     * This means that if an approved patch is reported as missing, this is the severity of the compliance violation.
     * Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, `UNSPECIFIED`.
     * The default value is `UNSPECIFIED`.
     */
    @JvmName("duaasurdqjwvwbnw")
    public suspend fun approvedPatchesComplianceLevel(`value`: Output<String>) {
        this.approvedPatchesComplianceLevel = value
    }

    /**
     * @param value Indicates whether the list of approved patches includes non-security updates that should be applied to the instances.
     * Applies to Linux instances only.
     */
    @JvmName("xdfhjxgmceoayndg")
    public suspend fun approvedPatchesEnableNonSecurity(`value`: Output<Boolean>) {
        this.approvedPatchesEnableNonSecurity = value
    }

    /**
     * @param value The description of the patch baseline.
     */
    @JvmName("yvpgulerqihrsjuj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A set of global filters used to exclude patches from the baseline.
     * Up to 4 global filters can be specified using Key/Value pairs.
     * Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("rxburjgwoxisuowd")
    public suspend fun globalFilters(`value`: Output<List<PatchBaselineGlobalFilterArgs>>) {
        this.globalFilters = value
    }

    @JvmName("ukdbtydjghuppmmc")
    public suspend fun globalFilters(vararg values: Output<PatchBaselineGlobalFilterArgs>) {
        this.globalFilters = Output.all(values.asList())
    }

    /**
     * @param values A set of global filters used to exclude patches from the baseline.
     * Up to 4 global filters can be specified using Key/Value pairs.
     * Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("fpwqyqwvmrdmaftq")
    public suspend fun globalFilters(values: List<Output<PatchBaselineGlobalFilterArgs>>) {
        this.globalFilters = Output.all(values)
    }

    /**
     * @param value The name of the patch baseline.
     */
    @JvmName("veiancixeyjwthep")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The operating system the patch baseline applies to.
     * Valid values are
     * `ALMA_LINUX`,
     * `AMAZON_LINUX`,
     * `AMAZON_LINUX_2`,
     * `AMAZON_LINUX_2022`,
     * `AMAZON_LINUX_2023`,
     * `CENTOS`,
     * `DEBIAN`,
     * `MACOS`,
     * `ORACLE_LINUX`,
     * `RASPBIAN`,
     * `REDHAT_ENTERPRISE_LINUX`,
     * `ROCKY_LINUX`,
     * `SUSE`,
     * `UBUNTU`, and
     * `WINDOWS`.
     * The default value is `WINDOWS`.
     */
    @JvmName("xtjrqgrjmxpsquuj")
    public suspend fun operatingSystem(`value`: Output<String>) {
        this.operatingSystem = value
    }

    /**
     * @param value A list of rejected patches.
     */
    @JvmName("ycgikdcwncxaqwgo")
    public suspend fun rejectedPatches(`value`: Output<List<String>>) {
        this.rejectedPatches = value
    }

    @JvmName("utplksalfaobbghq")
    public suspend fun rejectedPatches(vararg values: Output<String>) {
        this.rejectedPatches = Output.all(values.asList())
    }

    /**
     * @param values A list of rejected patches.
     */
    @JvmName("keyggxhoxbhrlfea")
    public suspend fun rejectedPatches(values: List<Output<String>>) {
        this.rejectedPatches = Output.all(values)
    }

    /**
     * @param value The action for Patch Manager to take on patches included in the `rejected_patches` list.
     * Valid values are `ALLOW_AS_DEPENDENCY` and `BLOCK`.
     */
    @JvmName("obytdoyenejfgoam")
    public suspend fun rejectedPatchesAction(`value`: Output<String>) {
        this.rejectedPatchesAction = value
    }

    /**
     * @param value Configuration block with alternate sources for patches.
     * Applies to Linux instances only.
     * See `source` below.
     */
    @JvmName("nbfkarqjgnvkqwnr")
    public suspend fun sources(`value`: Output<List<PatchBaselineSourceArgs>>) {
        this.sources = value
    }

    @JvmName("mwqyxqaarjtqmogo")
    public suspend fun sources(vararg values: Output<PatchBaselineSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values Configuration block with alternate sources for patches.
     * Applies to Linux instances only.
     * See `source` below.
     */
    @JvmName("mgcbltjrrqxenmul")
    public suspend fun sources(values: List<Output<PatchBaselineSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("luhwlapassxjtvkg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A set of rules used to include patches in the baseline.
     * Up to 10 approval rules can be specified.
     * See `approval_rule` below.
     */
    @JvmName("kurqulujnhneluip")
    public suspend fun approvalRules(`value`: List<PatchBaselineApprovalRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvalRules = mapped
    }

    /**
     * @param argument A set of rules used to include patches in the baseline.
     * Up to 10 approval rules can be specified.
     * See `approval_rule` below.
     */
    @JvmName("lfuxcjqtemiutlbn")
    public suspend
    fun approvalRules(argument: List<suspend PatchBaselineApprovalRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PatchBaselineApprovalRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param argument A set of rules used to include patches in the baseline.
     * Up to 10 approval rules can be specified.
     * See `approval_rule` below.
     */
    @JvmName("uydlptuulviycmql")
    public suspend fun approvalRules(
        vararg
        argument: suspend PatchBaselineApprovalRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PatchBaselineApprovalRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param argument A set of rules used to include patches in the baseline.
     * Up to 10 approval rules can be specified.
     * See `approval_rule` below.
     */
    @JvmName("railahbqiyggqxdr")
    public suspend
    fun approvalRules(argument: suspend PatchBaselineApprovalRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PatchBaselineApprovalRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param values A set of rules used to include patches in the baseline.
     * Up to 10 approval rules can be specified.
     * See `approval_rule` below.
     */
    @JvmName("vnquassbwentdtpd")
    public suspend fun approvalRules(vararg values: PatchBaselineApprovalRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.approvalRules = mapped
    }

    /**
     * @param value A list of explicitly approved patches for the baseline.
     * Cannot be specified with `approval_rule`.
     */
    @JvmName("jaqnpoqjketagdby")
    public suspend fun approvedPatches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvedPatches = mapped
    }

    /**
     * @param values A list of explicitly approved patches for the baseline.
     * Cannot be specified with `approval_rule`.
     */
    @JvmName("ngospvrudpdltryp")
    public suspend fun approvedPatches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.approvedPatches = mapped
    }

    /**
     * @param value The compliance level for approved patches.
     * This means that if an approved patch is reported as missing, this is the severity of the compliance violation.
     * Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, `UNSPECIFIED`.
     * The default value is `UNSPECIFIED`.
     */
    @JvmName("mfovoijdypldovfn")
    public suspend fun approvedPatchesComplianceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvedPatchesComplianceLevel = mapped
    }

    /**
     * @param value Indicates whether the list of approved patches includes non-security updates that should be applied to the instances.
     * Applies to Linux instances only.
     */
    @JvmName("hswuahogtabhprmh")
    public suspend fun approvedPatchesEnableNonSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvedPatchesEnableNonSecurity = mapped
    }

    /**
     * @param value The description of the patch baseline.
     */
    @JvmName("elgpijuhmokysiub")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A set of global filters used to exclude patches from the baseline.
     * Up to 4 global filters can be specified using Key/Value pairs.
     * Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("pmpqovnspvfftcvm")
    public suspend fun globalFilters(`value`: List<PatchBaselineGlobalFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalFilters = mapped
    }

    /**
     * @param argument A set of global filters used to exclude patches from the baseline.
     * Up to 4 global filters can be specified using Key/Value pairs.
     * Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("bwnedqjbdguvrqqh")
    public suspend
    fun globalFilters(argument: List<suspend PatchBaselineGlobalFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PatchBaselineGlobalFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.globalFilters = mapped
    }

    /**
     * @param argument A set of global filters used to exclude patches from the baseline.
     * Up to 4 global filters can be specified using Key/Value pairs.
     * Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("gkkdlkapnrraqefy")
    public suspend fun globalFilters(
        vararg
        argument: suspend PatchBaselineGlobalFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PatchBaselineGlobalFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.globalFilters = mapped
    }

    /**
     * @param argument A set of global filters used to exclude patches from the baseline.
     * Up to 4 global filters can be specified using Key/Value pairs.
     * Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("xnjhcjscmlpqloix")
    public suspend
    fun globalFilters(argument: suspend PatchBaselineGlobalFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PatchBaselineGlobalFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.globalFilters = mapped
    }

    /**
     * @param values A set of global filters used to exclude patches from the baseline.
     * Up to 4 global filters can be specified using Key/Value pairs.
     * Valid Keys are `PRODUCT`, `CLASSIFICATION`, `MSRC_SEVERITY`, and `PATCH_ID`.
     */
    @JvmName("bmujspxmbdywssii")
    public suspend fun globalFilters(vararg values: PatchBaselineGlobalFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.globalFilters = mapped
    }

    /**
     * @param value The name of the patch baseline.
     */
    @JvmName("fockqkmejlcyrswu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The operating system the patch baseline applies to.
     * Valid values are
     * `ALMA_LINUX`,
     * `AMAZON_LINUX`,
     * `AMAZON_LINUX_2`,
     * `AMAZON_LINUX_2022`,
     * `AMAZON_LINUX_2023`,
     * `CENTOS`,
     * `DEBIAN`,
     * `MACOS`,
     * `ORACLE_LINUX`,
     * `RASPBIAN`,
     * `REDHAT_ENTERPRISE_LINUX`,
     * `ROCKY_LINUX`,
     * `SUSE`,
     * `UBUNTU`, and
     * `WINDOWS`.
     * The default value is `WINDOWS`.
     */
    @JvmName("gpuyhiggcabvpigp")
    public suspend fun operatingSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingSystem = mapped
    }

    /**
     * @param value A list of rejected patches.
     */
    @JvmName("bclryajtyepjdswp")
    public suspend fun rejectedPatches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectedPatches = mapped
    }

    /**
     * @param values A list of rejected patches.
     */
    @JvmName("aeotfbejfkvkdngw")
    public suspend fun rejectedPatches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rejectedPatches = mapped
    }

    /**
     * @param value The action for Patch Manager to take on patches included in the `rejected_patches` list.
     * Valid values are `ALLOW_AS_DEPENDENCY` and `BLOCK`.
     */
    @JvmName("pflmsatqshvnrdtf")
    public suspend fun rejectedPatchesAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectedPatchesAction = mapped
    }

    /**
     * @param value Configuration block with alternate sources for patches.
     * Applies to Linux instances only.
     * See `source` below.
     */
    @JvmName("nwptdnvtkcugxyjw")
    public suspend fun sources(`value`: List<PatchBaselineSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument Configuration block with alternate sources for patches.
     * Applies to Linux instances only.
     * See `source` below.
     */
    @JvmName("fexvgbrbowxcbsgn")
    public suspend fun sources(argument: List<suspend PatchBaselineSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PatchBaselineSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Configuration block with alternate sources for patches.
     * Applies to Linux instances only.
     * See `source` below.
     */
    @JvmName("bttxcxelfvofqwkr")
    public suspend fun sources(vararg argument: suspend PatchBaselineSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PatchBaselineSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Configuration block with alternate sources for patches.
     * Applies to Linux instances only.
     * See `source` below.
     */
    @JvmName("rxyyxevsggquulpa")
    public suspend fun sources(argument: suspend PatchBaselineSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PatchBaselineSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values Configuration block with alternate sources for patches.
     * Applies to Linux instances only.
     * See `source` below.
     */
    @JvmName("eqxwmqvtieiauvds")
    public suspend fun sources(vararg values: PatchBaselineSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lnuvdogcubbqipvn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vyhqayeknoynsthr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PatchBaselineArgs = PatchBaselineArgs(
        approvalRules = approvalRules,
        approvedPatches = approvedPatches,
        approvedPatchesComplianceLevel = approvedPatchesComplianceLevel,
        approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity,
        description = description,
        globalFilters = globalFilters,
        name = name,
        operatingSystem = operatingSystem,
        rejectedPatches = rejectedPatches,
        rejectedPatchesAction = rejectedPatchesAction,
        sources = sources,
        tags = tags,
    )
}
