@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PatchGroup].
 */
@PulumiTagMarker
public class PatchGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PatchGroupArgs = PatchGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PatchGroupArgsBuilder.() -> Unit) {
        val builder = PatchGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PatchGroup {
        val builtJavaResource = com.pulumi.aws.ssm.PatchGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PatchGroup(builtJavaResource)
    }
}

/**
 * Provides an SSM Patch Group resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssm.PatchBaseline;
 * import com.pulumi.aws.ssm.PatchBaselineArgs;
 * import com.pulumi.aws.ssm.PatchGroup;
 * import com.pulumi.aws.ssm.PatchGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var production = new PatchBaseline("production", PatchBaselineArgs.builder()
 *             .approvedPatches("KB123456")
 *             .build());
 *         var patchgroup = new PatchGroup("patchgroup", PatchGroupArgs.builder()
 *             .baselineId(production.id())
 *             .patchGroup("patch-group-name")
 *             .build());
 *     }
 * }
 * ```
 */
public class PatchGroup internal constructor(
    override val javaResource: com.pulumi.aws.ssm.PatchGroup,
) : KotlinCustomResource(javaResource, PatchGroupMapper) {
    /**
     * The ID of the patch baseline to register the patch group with.
     */
    public val baselineId: Output<String>
        get() = javaResource.baselineId().applyValue({ args0 -> args0 })

    /**
     * The name of the patch group that should be registered with the patch baseline.
     */
    public val patchGroup: Output<String>
        get() = javaResource.patchGroup().applyValue({ args0 -> args0 })
}

public object PatchGroupMapper : ResourceMapper<PatchGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.PatchGroup::class == javaResource::class

    override fun map(javaResource: Resource): PatchGroup = PatchGroup(
        javaResource as
            com.pulumi.aws.ssm.PatchGroup,
    )
}

/**
 * @see [PatchGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PatchGroup].
 */
public suspend fun patchGroup(name: String, block: suspend PatchGroupResourceBuilder.() -> Unit):
    PatchGroup {
    val builder = PatchGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PatchGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun patchGroup(name: String): PatchGroup {
    val builder = PatchGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
