@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.kotlin.outputs.ResourceDataSyncS3Destination
import com.pulumi.aws.ssm.kotlin.outputs.ResourceDataSyncS3Destination.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResourceDataSync].
 */
@PulumiTagMarker
public class ResourceDataSyncResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceDataSyncArgs = ResourceDataSyncArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceDataSyncArgsBuilder.() -> Unit) {
        val builder = ResourceDataSyncArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResourceDataSync {
        val builtJavaResource = com.pulumi.aws.ssm.ResourceDataSync(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceDataSync(builtJavaResource)
    }
}

/**
 * Provides a SSM resource data sync.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.ssm.ResourceDataSync;
 * import com.pulumi.aws.ssm.ResourceDataSyncArgs;
 * import com.pulumi.aws.ssm.inputs.ResourceDataSyncS3DestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hogeBucketV2 = new BucketV2("hogeBucketV2");
 *         final var hogePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("SSMBucketPermissionsCheck")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("ssm.amazonaws.com")
 *                         .build())
 *                     .actions("s3:GetBucketAcl")
 *                     .resources("arn:aws:s3:::tf-test-bucket-1234")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("SSMBucketDelivery")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("ssm.amazonaws.com")
 *                         .build())
 *                     .actions("s3:PutObject")
 *                     .resources("arn:aws:s3:::tf-test-bucket-1234/*")
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("s3:x-amz-acl")
 *                         .values("bucket-owner-full-control")
 *                         .build())
 *                     .build())
 *             .build());
 *         var hogeBucketPolicy = new BucketPolicy("hogeBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(hogeBucketV2.id())
 *             .policy(hogePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var foo = new ResourceDataSync("foo", ResourceDataSyncArgs.builder()
 *             .s3Destination(ResourceDataSyncS3DestinationArgs.builder()
 *                 .bucketName(hogeBucketV2.bucket())
 *                 .region(hogeBucketV2.region())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM resource data sync using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/resourceDataSync:ResourceDataSync example example-name
 * ```
 * */
 */
public class ResourceDataSync internal constructor(
    override val javaResource: com.pulumi.aws.ssm.ResourceDataSync,
) : KotlinCustomResource(javaResource, ResourceDataSyncMapper) {
    /**
     * Name for the configuration.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Amazon S3 configuration details for the sync.
     */
    public val s3Destination: Output<ResourceDataSyncS3Destination>
        get() = javaResource.s3Destination().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object ResourceDataSyncMapper : ResourceMapper<ResourceDataSync> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssm.ResourceDataSync::class == javaResource::class

    override fun map(javaResource: Resource): ResourceDataSync = ResourceDataSync(
        javaResource as
            com.pulumi.aws.ssm.ResourceDataSync,
    )
}

/**
 * @see [ResourceDataSync].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceDataSync].
 */
public suspend fun resourceDataSync(
    name: String,
    block: suspend ResourceDataSyncResourceBuilder.() -> Unit,
): ResourceDataSync {
    val builder = ResourceDataSyncResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceDataSync].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceDataSync(name: String): ResourceDataSync {
    val builder = ResourceDataSyncResourceBuilder()
    builder.name(name)
    return builder.build()
}
