@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.ResourceDataSyncArgs.builder
import com.pulumi.aws.ssm.kotlin.inputs.ResourceDataSyncS3DestinationArgs
import com.pulumi.aws.ssm.kotlin.inputs.ResourceDataSyncS3DestinationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a SSM resource data sync.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.ssm.ResourceDataSync;
 * import com.pulumi.aws.ssm.ResourceDataSyncArgs;
 * import com.pulumi.aws.ssm.inputs.ResourceDataSyncS3DestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hogeBucketV2 = new BucketV2("hogeBucketV2");
 *         final var hogePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("SSMBucketPermissionsCheck")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("ssm.amazonaws.com")
 *                         .build())
 *                     .actions("s3:GetBucketAcl")
 *                     .resources("arn:aws:s3:::tf-test-bucket-1234")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("SSMBucketDelivery")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("ssm.amazonaws.com")
 *                         .build())
 *                     .actions("s3:PutObject")
 *                     .resources("arn:aws:s3:::tf-test-bucket-1234/*")
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("s3:x-amz-acl")
 *                         .values("bucket-owner-full-control")
 *                         .build())
 *                     .build())
 *             .build());
 *         var hogeBucketPolicy = new BucketPolicy("hogeBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(hogeBucketV2.id())
 *             .policy(hogePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var foo = new ResourceDataSync("foo", ResourceDataSyncArgs.builder()
 *             .s3Destination(ResourceDataSyncS3DestinationArgs.builder()
 *                 .bucketName(hogeBucketV2.bucket())
 *                 .region(hogeBucketV2.region())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM resource data sync using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:ssm/resourceDataSync:ResourceDataSync example example-name
 * ```
 * @property name Name for the configuration.
 * @property s3Destination Amazon S3 configuration details for the sync.
 * */
 */
public data class ResourceDataSyncArgs(
    public val name: Output<String>? = null,
    public val s3Destination: Output<ResourceDataSyncS3DestinationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.ResourceDataSyncArgs> {
    override fun toJava(): com.pulumi.aws.ssm.ResourceDataSyncArgs =
        com.pulumi.aws.ssm.ResourceDataSyncArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .s3Destination(s3Destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResourceDataSyncArgs].
 */
@PulumiTagMarker
public class ResourceDataSyncArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var s3Destination: Output<ResourceDataSyncS3DestinationArgs>? = null

    /**
     * @param value Name for the configuration.
     */
    @JvmName("jqawrykodmrkpalv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Amazon S3 configuration details for the sync.
     */
    @JvmName("xoiwxpcrdtbpafio")
    public suspend fun s3Destination(`value`: Output<ResourceDataSyncS3DestinationArgs>) {
        this.s3Destination = value
    }

    /**
     * @param value Name for the configuration.
     */
    @JvmName("gayajmiefxmsbafe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Amazon S3 configuration details for the sync.
     */
    @JvmName("rluffdvnkjmcovfg")
    public suspend fun s3Destination(`value`: ResourceDataSyncS3DestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Destination = mapped
    }

    /**
     * @param argument Amazon S3 configuration details for the sync.
     */
    @JvmName("paieosexcgjsrdpe")
    public suspend
    fun s3Destination(argument: suspend ResourceDataSyncS3DestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceDataSyncS3DestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3Destination = mapped
    }

    internal fun build(): ResourceDataSyncArgs = ResourceDataSyncArgs(
        name = name,
        s3Destination = s3Destination,
    )
}
