@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin

import com.pulumi.aws.ssm.SsmFunctions.getDocumentPlain
import com.pulumi.aws.ssm.SsmFunctions.getInstancesPlain
import com.pulumi.aws.ssm.SsmFunctions.getMaintenanceWindowsPlain
import com.pulumi.aws.ssm.SsmFunctions.getParameterPlain
import com.pulumi.aws.ssm.SsmFunctions.getParametersByPathPlain
import com.pulumi.aws.ssm.SsmFunctions.getPatchBaselinePlain
import com.pulumi.aws.ssm.kotlin.inputs.GetDocumentPlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetDocumentPlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.GetInstancesFilter
import com.pulumi.aws.ssm.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.GetMaintenanceWindowsFilter
import com.pulumi.aws.ssm.kotlin.inputs.GetMaintenanceWindowsPlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetMaintenanceWindowsPlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.GetParameterPlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetParameterPlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.GetParametersByPathPlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetParametersByPathPlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.inputs.GetPatchBaselinePlainArgs
import com.pulumi.aws.ssm.kotlin.inputs.GetPatchBaselinePlainArgsBuilder
import com.pulumi.aws.ssm.kotlin.outputs.GetDocumentResult
import com.pulumi.aws.ssm.kotlin.outputs.GetInstancesResult
import com.pulumi.aws.ssm.kotlin.outputs.GetMaintenanceWindowsResult
import com.pulumi.aws.ssm.kotlin.outputs.GetParameterResult
import com.pulumi.aws.ssm.kotlin.outputs.GetParametersByPathResult
import com.pulumi.aws.ssm.kotlin.outputs.GetPatchBaselineResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.ssm.kotlin.outputs.GetDocumentResult.Companion.toKotlin as getDocumentResultToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.GetMaintenanceWindowsResult.Companion.toKotlin as getMaintenanceWindowsResultToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.GetParameterResult.Companion.toKotlin as getParameterResultToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.GetParametersByPathResult.Companion.toKotlin as getParametersByPathResultToKotlin
import com.pulumi.aws.ssm.kotlin.outputs.GetPatchBaselineResult.Companion.toKotlin as getPatchBaselineResultToKotlin

public object SsmFunctions {
    /**
     * Gets the contents of the specified Systems Manager document.
     * ## Example Usage
     * To get the contents of the document owned by AWS.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = SsmFunctions.getDocument(GetDocumentArgs.builder()
     *             .name("AWS-GatherSoftwareInventory")
     *             .documentFormat("YAML")
     *             .build());
     *         ctx.export("content", foo.applyValue(getDocumentResult -> getDocumentResult.content()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDocument.
     * @return A collection of values returned by getDocument.
     */
    public suspend fun getDocument(argument: GetDocumentPlainArgs): GetDocumentResult =
        getDocumentResultToKotlin(getDocumentPlain(argument.toJava()).await())

    /**
     * @see [getDocument].
     * @param documentFormat Returns the document in the specified format. The document format can be either `JSON`, `YAML` and `TEXT`. JSON is the default format.
     * @param documentVersion Document version for which you want information.
     * @param name Name of the Systems Manager document.
     * @return A collection of values returned by getDocument.
     */
    public suspend fun getDocument(
        documentFormat: String? = null,
        documentVersion: String? = null,
        name: String,
    ): GetDocumentResult {
        val argument = GetDocumentPlainArgs(
            documentFormat = documentFormat,
            documentVersion = documentVersion,
            name = name,
        )
        return getDocumentResultToKotlin(getDocumentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDocument].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetDocumentPlainArgs].
     * @return A collection of values returned by getDocument.
     */
    public suspend fun getDocument(argument: suspend GetDocumentPlainArgsBuilder.() -> Unit):
        GetDocumentResult {
        val builder = GetDocumentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDocumentResultToKotlin(getDocumentPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the instance IDs of SSM managed instances.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsmFunctions.getInstances(GetInstancesArgs.builder()
     *             .filters(GetInstancesFilterArgs.builder()
     *                 .name("PlatformTypes")
     *                 .values("Linux")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(filters: List<GetInstancesFilter>? = null): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            filters = filters,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit):
        GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the window IDs of SSM maintenance windows.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetMaintenanceWindowsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsmFunctions.getMaintenanceWindows(GetMaintenanceWindowsArgs.builder()
     *             .filters(GetMaintenanceWindowsFilterArgs.builder()
     *                 .name("Enabled")
     *                 .values("true")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getMaintenanceWindows.
     * @return A collection of values returned by getMaintenanceWindows.
     */
    public suspend fun getMaintenanceWindows(argument: GetMaintenanceWindowsPlainArgs):
        GetMaintenanceWindowsResult =
        getMaintenanceWindowsResultToKotlin(getMaintenanceWindowsPlain(argument.toJava()).await())

    /**
     * @see [getMaintenanceWindows].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @return A collection of values returned by getMaintenanceWindows.
     */
    public suspend fun getMaintenanceWindows(filters: List<GetMaintenanceWindowsFilter>? = null):
        GetMaintenanceWindowsResult {
        val argument = GetMaintenanceWindowsPlainArgs(
            filters = filters,
        )
        return getMaintenanceWindowsResultToKotlin(getMaintenanceWindowsPlain(argument.toJava()).await())
    }

    /**
     * @see [getMaintenanceWindows].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetMaintenanceWindowsPlainArgs].
     * @return A collection of values returned by getMaintenanceWindows.
     */
    public suspend
    fun getMaintenanceWindows(argument: suspend GetMaintenanceWindowsPlainArgsBuilder.() -> Unit):
        GetMaintenanceWindowsResult {
        val builder = GetMaintenanceWindowsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMaintenanceWindowsResultToKotlin(getMaintenanceWindowsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides an SSM Parameter data source.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetParameterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = SsmFunctions.getParameter(GetParameterArgs.builder()
     *             .name("foo")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getParameter.
     * @return A collection of values returned by getParameter.
     */
    public suspend fun getParameter(argument: GetParameterPlainArgs): GetParameterResult =
        getParameterResultToKotlin(getParameterPlain(argument.toJava()).await())

    /**
     * @see [getParameter].
     * @param name Name of the parameter.
     * @param withDecryption Whether to return decrypted `SecureString` value. Defaults to `true`.
     * In addition to all arguments above, the following attributes are exported:
     * @return A collection of values returned by getParameter.
     */
    public suspend fun getParameter(name: String, withDecryption: Boolean? = null):
        GetParameterResult {
        val argument = GetParameterPlainArgs(
            name = name,
            withDecryption = withDecryption,
        )
        return getParameterResultToKotlin(getParameterPlain(argument.toJava()).await())
    }

    /**
     * @see [getParameter].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetParameterPlainArgs].
     * @return A collection of values returned by getParameter.
     */
    public suspend fun getParameter(argument: suspend GetParameterPlainArgsBuilder.() -> Unit):
        GetParameterResult {
        val builder = GetParameterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getParameterResultToKotlin(getParameterPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getParametersByPath.
     * @return A collection of values returned by getParametersByPath.
     */
    public suspend fun getParametersByPath(argument: GetParametersByPathPlainArgs):
        GetParametersByPathResult =
        getParametersByPathResultToKotlin(getParametersByPathPlain(argument.toJava()).await())

    /**
     * @see [getParametersByPath].
     * @param path The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierarchy is the parameter name except the last part of the parameter. The last part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of 15 levels. **Note:** If the parameter name (e.g., `/my-app/my-param`) is specified, the data source will not retrieve any value as designed, unless there are other parameters that happen to use the former path in their hierarchy (e.g., `/my-app/my-param/my-actual-param`).
     * @param recursive Whether to retrieve all parameters within the hirerachy. Defaults to `false`.
     * @param withDecryption Whether to retrieve all parameters in the hierarchy, particularly those of `SecureString` type, with their value decrypted. Defaults to `true`.
     * @return A collection of values returned by getParametersByPath.
     */
    public suspend fun getParametersByPath(
        path: String,
        recursive: Boolean? = null,
        withDecryption: Boolean? = null,
    ): GetParametersByPathResult {
        val argument = GetParametersByPathPlainArgs(
            path = path,
            recursive = recursive,
            withDecryption = withDecryption,
        )
        return getParametersByPathResultToKotlin(getParametersByPathPlain(argument.toJava()).await())
    }

    /**
     * @see [getParametersByPath].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetParametersByPathPlainArgs].
     * @return A collection of values returned by getParametersByPath.
     */
    public suspend
    fun getParametersByPath(argument: suspend GetParametersByPathPlainArgsBuilder.() -> Unit):
        GetParametersByPathResult {
        val builder = GetParametersByPathPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getParametersByPathResultToKotlin(getParametersByPathPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides an SSM Patch Baseline data source. Useful if you wish to reuse the default baselines provided.
     * ## Example Usage
     * To retrieve a baseline provided by AWS:
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssm.SsmFunctions;
     * import com.pulumi.aws.ssm.inputs.GetPatchBaselineArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var centos = SsmFunctions.getPatchBaseline(GetPatchBaselineArgs.builder()
     *             .namePrefix("AWS-")
     *             .operatingSystem("CENTOS")
     *             .owner("AWS")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPatchBaseline.
     * @return A collection of values returned by getPatchBaseline.
     */
    public suspend fun getPatchBaseline(argument: GetPatchBaselinePlainArgs): GetPatchBaselineResult =
        getPatchBaselineResultToKotlin(getPatchBaselinePlain(argument.toJava()).await())

    /**
     * @see [getPatchBaseline].
     * @param defaultBaseline Filters the results against the baselines default_baseline field.
     * @param namePrefix Filter results by the baseline name prefix.
     * @param operatingSystem Specified OS for the baseline. Valid values: `AMAZON_LINUX`, `AMAZON_LINUX_2`, `UBUNTU`, `REDHAT_ENTERPRISE_LINUX`, `SUSE`, `CENTOS`, `ORACLE_LINUX`, `DEBIAN`, `MACOS`, `RASPBIAN` and `ROCKY_LINUX`.
     * @param owner Owner of the baseline. Valid values: `All`, `AWS`, `Self` (the current account).
     * @return A collection of values returned by getPatchBaseline.
     */
    public suspend fun getPatchBaseline(
        defaultBaseline: Boolean? = null,
        namePrefix: String? = null,
        operatingSystem: String? = null,
        owner: String,
    ): GetPatchBaselineResult {
        val argument = GetPatchBaselinePlainArgs(
            defaultBaseline = defaultBaseline,
            namePrefix = namePrefix,
            operatingSystem = operatingSystem,
            owner = owner,
        )
        return getPatchBaselineResultToKotlin(getPatchBaselinePlain(argument.toJava()).await())
    }

    /**
     * @see [getPatchBaseline].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssm&#46;kotlin&#46;inputs&#46;GetPatchBaselinePlainArgs].
     * @return A collection of values returned by getPatchBaseline.
     */
    public suspend
    fun getPatchBaseline(argument: suspend GetPatchBaselinePlainArgsBuilder.() -> Unit):
        GetPatchBaselineResult {
        val builder = GetPatchBaselinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPatchBaselineResultToKotlin(getPatchBaselinePlain(builtArgument.toJava()).await())
    }
}
