@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.AssociationTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key Either `InstanceIds` or `tag:Tag Name` to specify an EC2 tag.
 * @property values A list of instance IDs or tag values. AWS currently limits this list size to one value.
 */
public data class AssociationTargetArgs(
    public val key: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.AssociationTargetArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.AssociationTargetArgs =
        com.pulumi.aws.ssm.inputs.AssociationTargetArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AssociationTargetArgs].
 */
@PulumiTagMarker
public class AssociationTargetArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Either `InstanceIds` or `tag:Tag Name` to specify an EC2 tag.
     */
    @JvmName("bexlrknkosgperna")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value A list of instance IDs or tag values. AWS currently limits this list size to one value.
     */
    @JvmName("wbwhqkybetmssvow")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("atnpfcehtfvxudcg")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values A list of instance IDs or tag values. AWS currently limits this list size to one value.
     */
    @JvmName("jmbfohqqpbqywbhe")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Either `InstanceIds` or `tag:Tag Name` to specify an EC2 tag.
     */
    @JvmName("hopbfejegdkeetit")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value A list of instance IDs or tag values. AWS currently limits this list size to one value.
     */
    @JvmName("rwoljoiuqjiymekm")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values A list of instance IDs or tag values. AWS currently limits this list size to one value.
     */
    @JvmName("gfeheqjmnxmwsoyd")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): AssociationTargetArgs = AssociationTargetArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
