@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.DocumentAttachmentsSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key The key describing the location of an attachment to a document. Valid key types include: `SourceUrl` and `S3FileUrl`
 * @property name The name of the document attachment file
 * @property values The value describing the location of an attachment to a document
 */
public data class DocumentAttachmentsSourceArgs(
    public val key: Output<String>,
    public val name: Output<String>? = null,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.DocumentAttachmentsSourceArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.DocumentAttachmentsSourceArgs =
        com.pulumi.aws.ssm.inputs.DocumentAttachmentsSourceArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DocumentAttachmentsSourceArgs].
 */
@PulumiTagMarker
public class DocumentAttachmentsSourceArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var name: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The key describing the location of an attachment to a document. Valid key types include: `SourceUrl` and `S3FileUrl`
     */
    @JvmName("rsmarvpkarbfgvqx")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The name of the document attachment file
     */
    @JvmName("xyviwnovdwhhncji")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value describing the location of an attachment to a document
     */
    @JvmName("sctfrhsyprrnqrox")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("whyflqssqnvmpihw")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The value describing the location of an attachment to a document
     */
    @JvmName("dsqgoxhveubsfasq")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The key describing the location of an attachment to a document. Valid key types include: `SourceUrl` and `S3FileUrl`
     */
    @JvmName("iwfadqshofeiyonb")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The name of the document attachment file
     */
    @JvmName("jxujsfuattupsyrb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value describing the location of an attachment to a document
     */
    @JvmName("ifeawrtskephtdcs")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The value describing the location of an attachment to a document
     */
    @JvmName("rcdtbptrvghsiufb")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): DocumentAttachmentsSourceArgs = DocumentAttachmentsSourceArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        name = name,
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
