@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.GetDocumentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDocument.
 * @property documentFormat Returns the document in the specified format. The document format can be either `JSON`, `YAML` and `TEXT`. JSON is the default format.
 * @property documentVersion Document version for which you want information.
 * @property name Name of the Systems Manager document.
 */
public data class GetDocumentPlainArgs(
    public val documentFormat: String? = null,
    public val documentVersion: String? = null,
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.GetDocumentPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.GetDocumentPlainArgs =
        com.pulumi.aws.ssm.inputs.GetDocumentPlainArgs.builder()
            .documentFormat(documentFormat?.let({ args0 -> args0 }))
            .documentVersion(documentVersion?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDocumentPlainArgs].
 */
@PulumiTagMarker
public class GetDocumentPlainArgsBuilder internal constructor() {
    private var documentFormat: String? = null

    private var documentVersion: String? = null

    private var name: String? = null

    /**
     * @param value Returns the document in the specified format. The document format can be either `JSON`, `YAML` and `TEXT`. JSON is the default format.
     */
    @JvmName("yqamfqwxblghhvbl")
    public suspend fun documentFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.documentFormat = mapped
    }

    /**
     * @param value Document version for which you want information.
     */
    @JvmName("jpytyahpjcffgyhe")
    public suspend fun documentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.documentVersion = mapped
    }

    /**
     * @param value Name of the Systems Manager document.
     */
    @JvmName("xpfabjhhxeuvhtqx")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetDocumentPlainArgs = GetDocumentPlainArgs(
        documentFormat = documentFormat,
        documentVersion = documentVersion,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
