@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.GetMaintenanceWindowsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMaintenanceWindows.
 * @property filters Configuration block(s) for filtering. Detailed below.
 */
public data class GetMaintenanceWindowsPlainArgs(
    public val filters: List<GetMaintenanceWindowsFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.GetMaintenanceWindowsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.GetMaintenanceWindowsPlainArgs =
        com.pulumi.aws.ssm.inputs.GetMaintenanceWindowsPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetMaintenanceWindowsPlainArgs].
 */
@PulumiTagMarker
public class GetMaintenanceWindowsPlainArgsBuilder internal constructor() {
    private var filters: List<GetMaintenanceWindowsFilter>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("huiyxbtjcmhfyjom")
    public suspend fun filters(`value`: List<GetMaintenanceWindowsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("rjaqttygnnbmplfe")
    public suspend
    fun filters(argument: List<suspend GetMaintenanceWindowsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetMaintenanceWindowsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("kxxjtjbrjimcetqp")
    public suspend fun filters(
        vararg
        argument: suspend GetMaintenanceWindowsFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetMaintenanceWindowsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("hbgratuwtxpjumwy")
    public suspend fun filters(argument: suspend GetMaintenanceWindowsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetMaintenanceWindowsFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("whmldwybkxgxyjul")
    public suspend fun filters(vararg values: GetMaintenanceWindowsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetMaintenanceWindowsPlainArgs = GetMaintenanceWindowsPlainArgs(
        filters = filters,
    )
}
