@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.GetParameterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getParameter.
 * @property name Name of the parameter.
 * @property withDecryption Whether to return decrypted `SecureString` value. Defaults to `true`.
 * In addition to all arguments above, the following attributes are exported:
 */
public data class GetParameterPlainArgs(
    public val name: String,
    public val withDecryption: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.GetParameterPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.GetParameterPlainArgs =
        com.pulumi.aws.ssm.inputs.GetParameterPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .withDecryption(withDecryption?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetParameterPlainArgs].
 */
@PulumiTagMarker
public class GetParameterPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var withDecryption: Boolean? = null

    /**
     * @param value Name of the parameter.
     */
    @JvmName("wknmllswctwkwlsh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Whether to return decrypted `SecureString` value. Defaults to `true`.
     * In addition to all arguments above, the following attributes are exported:
     */
    @JvmName("kjiojysomemwujmj")
    public suspend fun withDecryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.withDecryption = mapped
    }

    internal fun build(): GetParameterPlainArgs = GetParameterPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        withDecryption = withDecryption,
    )
}
