@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.GetPatchBaselinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPatchBaseline.
 * @property defaultBaseline Filters the results against the baselines default_baseline field.
 * @property namePrefix Filter results by the baseline name prefix.
 * @property operatingSystem Specified OS for the baseline. Valid values: `AMAZON_LINUX`, `AMAZON_LINUX_2`, `UBUNTU`, `REDHAT_ENTERPRISE_LINUX`, `SUSE`, `CENTOS`, `ORACLE_LINUX`, `DEBIAN`, `MACOS`, `RASPBIAN` and `ROCKY_LINUX`.
 * @property owner Owner of the baseline. Valid values: `All`, `AWS`, `Self` (the current account).
 */
public data class GetPatchBaselinePlainArgs(
    public val defaultBaseline: Boolean? = null,
    public val namePrefix: String? = null,
    public val operatingSystem: String? = null,
    public val owner: String,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.GetPatchBaselinePlainArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.GetPatchBaselinePlainArgs =
        com.pulumi.aws.ssm.inputs.GetPatchBaselinePlainArgs.builder()
            .defaultBaseline(defaultBaseline?.let({ args0 -> args0 }))
            .namePrefix(namePrefix?.let({ args0 -> args0 }))
            .operatingSystem(operatingSystem?.let({ args0 -> args0 }))
            .owner(owner.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPatchBaselinePlainArgs].
 */
@PulumiTagMarker
public class GetPatchBaselinePlainArgsBuilder internal constructor() {
    private var defaultBaseline: Boolean? = null

    private var namePrefix: String? = null

    private var operatingSystem: String? = null

    private var owner: String? = null

    /**
     * @param value Filters the results against the baselines default_baseline field.
     */
    @JvmName("rivxameqimonmavw")
    public suspend fun defaultBaseline(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.defaultBaseline = mapped
    }

    /**
     * @param value Filter results by the baseline name prefix.
     */
    @JvmName("ouslojihbvgfwpbk")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namePrefix = mapped
    }

    /**
     * @param value Specified OS for the baseline. Valid values: `AMAZON_LINUX`, `AMAZON_LINUX_2`, `UBUNTU`, `REDHAT_ENTERPRISE_LINUX`, `SUSE`, `CENTOS`, `ORACLE_LINUX`, `DEBIAN`, `MACOS`, `RASPBIAN` and `ROCKY_LINUX`.
     */
    @JvmName("oliyjwnpnjvfeyxf")
    public suspend fun operatingSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.operatingSystem = mapped
    }

    /**
     * @param value Owner of the baseline. Valid values: `All`, `AWS`, `Self` (the current account).
     */
    @JvmName("urcovhknifxfciju")
    public suspend fun owner(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.owner = mapped
    }

    internal fun build(): GetPatchBaselinePlainArgs = GetPatchBaselinePlainArgs(
        defaultBaseline = defaultBaseline,
        namePrefix = namePrefix,
        operatingSystem = operatingSystem,
        owner = owner ?: throw PulumiNullFieldException("owner"),
    )
}
