@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.MaintenanceWindowTargetTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key
 * @property values
 */
public data class MaintenanceWindowTargetTargetArgs(
    public val key: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.MaintenanceWindowTargetTargetArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.MaintenanceWindowTargetTargetArgs =
        com.pulumi.aws.ssm.inputs.MaintenanceWindowTargetTargetArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [MaintenanceWindowTargetTargetArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowTargetTargetArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("mbmkldtlbqovricp")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value
     */
    @JvmName("otuvolhyfhjcmhte")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("yjeatebtxnsioxpv")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("hnsyqtkotmackgks")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hqaxsgufugjiahjl")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value
     */
    @JvmName("rdmtlddisyvfmtsg")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("bdscnrljuctviemi")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): MaintenanceWindowTargetTargetArgs = MaintenanceWindowTargetTargetArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
