@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property automationParameters The parameters for an AUTOMATION task type. Documented below.
 * @property lambdaParameters The parameters for a LAMBDA task type. Documented below.
 * @property runCommandParameters The parameters for a RUN_COMMAND task type. Documented below.
 * @property stepFunctionsParameters The parameters for a STEP_FUNCTIONS task type. Documented below.
 */
public data class MaintenanceWindowTaskTaskInvocationParametersArgs(
    public val automationParameters:
    Output<MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs>? = null,
    public val lambdaParameters:
    Output<MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs>? = null,
    public val runCommandParameters:
    Output<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs>? = null,
    public val stepFunctionsParameters:
    Output<MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs =
        com.pulumi.aws.ssm.inputs.MaintenanceWindowTaskTaskInvocationParametersArgs.builder()
            .automationParameters(
                automationParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lambdaParameters(lambdaParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .runCommandParameters(
                runCommandParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .stepFunctionsParameters(
                stepFunctionsParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MaintenanceWindowTaskTaskInvocationParametersArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowTaskTaskInvocationParametersArgsBuilder internal constructor() {
    private var automationParameters:
        Output<MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs>? = null

    private var lambdaParameters:
        Output<MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs>? = null

    private var runCommandParameters:
        Output<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs>? = null

    private var stepFunctionsParameters:
        Output<MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs>? = null

    /**
     * @param value The parameters for an AUTOMATION task type. Documented below.
     */
    @JvmName("ryekfnlgtoyujbdd")
    public suspend
    fun automationParameters(`value`: Output<MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs>) {
        this.automationParameters = value
    }

    /**
     * @param value The parameters for a LAMBDA task type. Documented below.
     */
    @JvmName("vydivtvgdgppfsgk")
    public suspend
    fun lambdaParameters(`value`: Output<MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs>) {
        this.lambdaParameters = value
    }

    /**
     * @param value The parameters for a RUN_COMMAND task type. Documented below.
     */
    @JvmName("xwrasmumwlkhxskn")
    public suspend
    fun runCommandParameters(`value`: Output<MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs>) {
        this.runCommandParameters = value
    }

    /**
     * @param value The parameters for a STEP_FUNCTIONS task type. Documented below.
     */
    @JvmName("dwnpibkryiwhvokn")
    public suspend
    fun stepFunctionsParameters(`value`: Output<MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs>) {
        this.stepFunctionsParameters = value
    }

    /**
     * @param value The parameters for an AUTOMATION task type. Documented below.
     */
    @JvmName("kamavxjlsegdupln")
    public suspend
    fun automationParameters(`value`: MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationParameters = mapped
    }

    /**
     * @param argument The parameters for an AUTOMATION task type. Documented below.
     */
    @JvmName("lyngdrqcbcecxlls")
    public suspend
    fun automationParameters(argument: suspend MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.automationParameters = mapped
    }

    /**
     * @param value The parameters for a LAMBDA task type. Documented below.
     */
    @JvmName("hbthodcnwjccxabo")
    public suspend
    fun lambdaParameters(`value`: MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaParameters = mapped
    }

    /**
     * @param argument The parameters for a LAMBDA task type. Documented below.
     */
    @JvmName("fnhapsnfuliiupty")
    public suspend
    fun lambdaParameters(argument: suspend MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.lambdaParameters = mapped
    }

    /**
     * @param value The parameters for a RUN_COMMAND task type. Documented below.
     */
    @JvmName("ptepggdysyijwqtr")
    public suspend
    fun runCommandParameters(`value`: MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runCommandParameters = mapped
    }

    /**
     * @param argument The parameters for a RUN_COMMAND task type. Documented below.
     */
    @JvmName("dqovkmridttdnhwk")
    public suspend
    fun runCommandParameters(argument: suspend MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.runCommandParameters = mapped
    }

    /**
     * @param value The parameters for a STEP_FUNCTIONS task type. Documented below.
     */
    @JvmName("ubmimlxfhpubcnfn")
    public suspend
    fun stepFunctionsParameters(`value`: MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepFunctionsParameters = mapped
    }

    /**
     * @param argument The parameters for a STEP_FUNCTIONS task type. Documented below.
     */
    @JvmName("namlnwmldwrwnool")
    public suspend
    fun stepFunctionsParameters(argument: suspend MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.stepFunctionsParameters = mapped
    }

    internal fun build(): MaintenanceWindowTaskTaskInvocationParametersArgs =
        MaintenanceWindowTaskTaskInvocationParametersArgs(
            automationParameters = automationParameters,
            lambdaParameters = lambdaParameters,
            runCommandParameters = runCommandParameters,
            stepFunctionsParameters = stepFunctionsParameters,
        )
}
