@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property approveAfterDays The number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.
 * Valid Range: 0 to 100.
 * Conflicts with `approve_until_date`.
 * @property approveUntilDate The cutoff date for auto approval of released patches.
 * Any patches released on or before this date are installed automatically.
 * Date is formatted as `YYYY-MM-DD`.
 * Conflicts with `approve_after_days`
 * @property complianceLevel The compliance level for patches approved by this rule.
 * Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, and `UNSPECIFIED`.
 * The default value is `UNSPECIFIED`.
 * @property enableNonSecurity Boolean enabling the application of non-security updates.
 * The default value is `false`.
 * Valid for Linux instances only.
 * @property patchFilters The patch filter group that defines the criteria for the rule.
 * Up to 5 patch filters can be specified per approval rule using Key/Value pairs.
 * Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html).
 * Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values.
 */
public data class PatchBaselineApprovalRuleArgs(
    public val approveAfterDays: Output<Int>? = null,
    public val approveUntilDate: Output<String>? = null,
    public val complianceLevel: Output<String>? = null,
    public val enableNonSecurity: Output<Boolean>? = null,
    public val patchFilters: Output<List<PatchBaselineApprovalRulePatchFilterArgs>>,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs =
        com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRuleArgs.builder()
            .approveAfterDays(approveAfterDays?.applyValue({ args0 -> args0 }))
            .approveUntilDate(approveUntilDate?.applyValue({ args0 -> args0 }))
            .complianceLevel(complianceLevel?.applyValue({ args0 -> args0 }))
            .enableNonSecurity(enableNonSecurity?.applyValue({ args0 -> args0 }))
            .patchFilters(
                patchFilters.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PatchBaselineApprovalRuleArgs].
 */
@PulumiTagMarker
public class PatchBaselineApprovalRuleArgsBuilder internal constructor() {
    private var approveAfterDays: Output<Int>? = null

    private var approveUntilDate: Output<String>? = null

    private var complianceLevel: Output<String>? = null

    private var enableNonSecurity: Output<Boolean>? = null

    private var patchFilters: Output<List<PatchBaselineApprovalRulePatchFilterArgs>>? = null

    /**
     * @param value The number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.
     * Valid Range: 0 to 100.
     * Conflicts with `approve_until_date`.
     */
    @JvmName("yegmytnhtfcuutrn")
    public suspend fun approveAfterDays(`value`: Output<Int>) {
        this.approveAfterDays = value
    }

    /**
     * @param value The cutoff date for auto approval of released patches.
     * Any patches released on or before this date are installed automatically.
     * Date is formatted as `YYYY-MM-DD`.
     * Conflicts with `approve_after_days`
     */
    @JvmName("uomqoarkfbndebqg")
    public suspend fun approveUntilDate(`value`: Output<String>) {
        this.approveUntilDate = value
    }

    /**
     * @param value The compliance level for patches approved by this rule.
     * Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, and `UNSPECIFIED`.
     * The default value is `UNSPECIFIED`.
     */
    @JvmName("aojauawuxdcuicrp")
    public suspend fun complianceLevel(`value`: Output<String>) {
        this.complianceLevel = value
    }

    /**
     * @param value Boolean enabling the application of non-security updates.
     * The default value is `false`.
     * Valid for Linux instances only.
     */
    @JvmName("kmiunjcdogasesst")
    public suspend fun enableNonSecurity(`value`: Output<Boolean>) {
        this.enableNonSecurity = value
    }

    /**
     * @param value The patch filter group that defines the criteria for the rule.
     * Up to 5 patch filters can be specified per approval rule using Key/Value pairs.
     * Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html).
     * Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values.
     */
    @JvmName("jvkpatkjkuojtash")
    public suspend fun patchFilters(`value`: Output<List<PatchBaselineApprovalRulePatchFilterArgs>>) {
        this.patchFilters = value
    }

    @JvmName("ihqeilxxierakgmd")
    public suspend fun patchFilters(vararg values: Output<PatchBaselineApprovalRulePatchFilterArgs>) {
        this.patchFilters = Output.all(values.asList())
    }

    /**
     * @param values The patch filter group that defines the criteria for the rule.
     * Up to 5 patch filters can be specified per approval rule using Key/Value pairs.
     * Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html).
     * Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values.
     */
    @JvmName("ysegfclgfbwabifw")
    public suspend fun patchFilters(values: List<Output<PatchBaselineApprovalRulePatchFilterArgs>>) {
        this.patchFilters = Output.all(values)
    }

    /**
     * @param value The number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.
     * Valid Range: 0 to 100.
     * Conflicts with `approve_until_date`.
     */
    @JvmName("adhvlowodtywkykg")
    public suspend fun approveAfterDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approveAfterDays = mapped
    }

    /**
     * @param value The cutoff date for auto approval of released patches.
     * Any patches released on or before this date are installed automatically.
     * Date is formatted as `YYYY-MM-DD`.
     * Conflicts with `approve_after_days`
     */
    @JvmName("yelcwlybrstbdqni")
    public suspend fun approveUntilDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approveUntilDate = mapped
    }

    /**
     * @param value The compliance level for patches approved by this rule.
     * Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, and `UNSPECIFIED`.
     * The default value is `UNSPECIFIED`.
     */
    @JvmName("cadglqiorlfigqpx")
    public suspend fun complianceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceLevel = mapped
    }

    /**
     * @param value Boolean enabling the application of non-security updates.
     * The default value is `false`.
     * Valid for Linux instances only.
     */
    @JvmName("aqnxywwejnavjxvv")
    public suspend fun enableNonSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNonSecurity = mapped
    }

    /**
     * @param value The patch filter group that defines the criteria for the rule.
     * Up to 5 patch filters can be specified per approval rule using Key/Value pairs.
     * Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html).
     * Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values.
     */
    @JvmName("fdgdpjcmekrroyia")
    public suspend fun patchFilters(`value`: List<PatchBaselineApprovalRulePatchFilterArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patchFilters = mapped
    }

    /**
     * @param argument The patch filter group that defines the criteria for the rule.
     * Up to 5 patch filters can be specified per approval rule using Key/Value pairs.
     * Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html).
     * Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values.
     */
    @JvmName("qdmbtsbcadnxtlxe")
    public suspend
    fun patchFilters(argument: List<suspend PatchBaselineApprovalRulePatchFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PatchBaselineApprovalRulePatchFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.patchFilters = mapped
    }

    /**
     * @param argument The patch filter group that defines the criteria for the rule.
     * Up to 5 patch filters can be specified per approval rule using Key/Value pairs.
     * Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html).
     * Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values.
     */
    @JvmName("sdvrrdlhmhdhytrd")
    public suspend fun patchFilters(
        vararg
        argument: suspend PatchBaselineApprovalRulePatchFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PatchBaselineApprovalRulePatchFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.patchFilters = mapped
    }

    /**
     * @param argument The patch filter group that defines the criteria for the rule.
     * Up to 5 patch filters can be specified per approval rule using Key/Value pairs.
     * Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html).
     * Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values.
     */
    @JvmName("ogeojhqfsemluvix")
    public suspend
    fun patchFilters(argument: suspend PatchBaselineApprovalRulePatchFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PatchBaselineApprovalRulePatchFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.patchFilters = mapped
    }

    /**
     * @param values The patch filter group that defines the criteria for the rule.
     * Up to 5 patch filters can be specified per approval rule using Key/Value pairs.
     * Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html).
     * Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values.
     */
    @JvmName("drgahvftfmfnmswn")
    public suspend fun patchFilters(vararg values: PatchBaselineApprovalRulePatchFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.patchFilters = mapped
    }

    internal fun build(): PatchBaselineApprovalRuleArgs = PatchBaselineApprovalRuleArgs(
        approveAfterDays = approveAfterDays,
        approveUntilDate = approveUntilDate,
        complianceLevel = complianceLevel,
        enableNonSecurity = enableNonSecurity,
        patchFilters = patchFilters ?: throw PulumiNullFieldException("patchFilters"),
    )
}
