@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRulePatchFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key
 * @property values
 */
public data class PatchBaselineApprovalRulePatchFilterArgs(
    public val key: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRulePatchFilterArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRulePatchFilterArgs =
        com.pulumi.aws.ssm.inputs.PatchBaselineApprovalRulePatchFilterArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PatchBaselineApprovalRulePatchFilterArgs].
 */
@PulumiTagMarker
public class PatchBaselineApprovalRulePatchFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("jjqetevycnarowup")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value
     */
    @JvmName("uwlakrbnvtjildbs")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("tonuptobaxflvkwl")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("lqijxsjepvgjntwb")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("wesuwwgbkjxaovvv")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value
     */
    @JvmName("qoehmjjremtgistd")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("ninyjdljfodohxip")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): PatchBaselineApprovalRulePatchFilterArgs =
        PatchBaselineApprovalRulePatchFilterArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            values = values ?: throw PulumiNullFieldException("values"),
        )
}
