@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.PatchBaselineSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property configuration The value of the yum repo configuration.
 * For information about other options available for your yum repository configuration, see the [`dnf&#46;conf` documentation](https://man7.org/linux/man-pages/man5/dnf.conf.5.html)
 * @property name The name specified to identify the patch source.
 * @property products The specific operating system versions a patch repository applies to, such as `"Ubuntu16.04"`, `"AmazonLinux2016.09"`, `"RedhatEnterpriseLinux7.2"` or `"Suse12.7"`.
 * For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
 */
public data class PatchBaselineSourceArgs(
    public val configuration: Output<String>,
    public val name: Output<String>,
    public val products: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.PatchBaselineSourceArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.PatchBaselineSourceArgs =
        com.pulumi.aws.ssm.inputs.PatchBaselineSourceArgs.builder()
            .configuration(configuration.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .products(products.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PatchBaselineSourceArgs].
 */
@PulumiTagMarker
public class PatchBaselineSourceArgsBuilder internal constructor() {
    private var configuration: Output<String>? = null

    private var name: Output<String>? = null

    private var products: Output<List<String>>? = null

    /**
     * @param value The value of the yum repo configuration.
     * For information about other options available for your yum repository configuration, see the [`dnf&#46;conf` documentation](https://man7.org/linux/man-pages/man5/dnf.conf.5.html)
     */
    @JvmName("sojhkeivtjxkaool")
    public suspend fun configuration(`value`: Output<String>) {
        this.configuration = value
    }

    /**
     * @param value The name specified to identify the patch source.
     */
    @JvmName("qhwgygearyrkebpj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The specific operating system versions a patch repository applies to, such as `"Ubuntu16.04"`, `"AmazonLinux2016.09"`, `"RedhatEnterpriseLinux7.2"` or `"Suse12.7"`.
     * For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
     */
    @JvmName("fxywfbvyuwsickac")
    public suspend fun products(`value`: Output<List<String>>) {
        this.products = value
    }

    @JvmName("joryyxcngbydlijr")
    public suspend fun products(vararg values: Output<String>) {
        this.products = Output.all(values.asList())
    }

    /**
     * @param values The specific operating system versions a patch repository applies to, such as `"Ubuntu16.04"`, `"AmazonLinux2016.09"`, `"RedhatEnterpriseLinux7.2"` or `"Suse12.7"`.
     * For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
     */
    @JvmName("emwnsjppadxinndu")
    public suspend fun products(values: List<Output<String>>) {
        this.products = Output.all(values)
    }

    /**
     * @param value The value of the yum repo configuration.
     * For information about other options available for your yum repository configuration, see the [`dnf&#46;conf` documentation](https://man7.org/linux/man-pages/man5/dnf.conf.5.html)
     */
    @JvmName("theajhakoqpsgcij")
    public suspend fun configuration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value The name specified to identify the patch source.
     */
    @JvmName("jsydeppeuwiumcla")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The specific operating system versions a patch repository applies to, such as `"Ubuntu16.04"`, `"AmazonLinux2016.09"`, `"RedhatEnterpriseLinux7.2"` or `"Suse12.7"`.
     * For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
     */
    @JvmName("fmltuudtdkvwfnjy")
    public suspend fun products(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.products = mapped
    }

    /**
     * @param values The specific operating system versions a patch repository applies to, such as `"Ubuntu16.04"`, `"AmazonLinux2016.09"`, `"RedhatEnterpriseLinux7.2"` or `"Suse12.7"`.
     * For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
     */
    @JvmName("tgxmilkgvecwpksh")
    public suspend fun products(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.products = mapped
    }

    internal fun build(): PatchBaselineSourceArgs = PatchBaselineSourceArgs(
        configuration = configuration ?: throw PulumiNullFieldException("configuration"),
        name = name ?: throw PulumiNullFieldException("name"),
        products = products ?: throw PulumiNullFieldException("products"),
    )
}
