@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.inputs

import com.pulumi.aws.ssm.inputs.ResourceDataSyncS3DestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName Name of S3 bucket where the aggregated data is stored.
 * @property kmsKeyArn ARN of an encryption key for a destination in Amazon S3.
 * @property prefix Prefix for the bucket.
 * @property region Region with the bucket targeted by the Resource Data Sync.
 * @property syncFormat A supported sync format. Only JsonSerDe is currently supported. Defaults to JsonSerDe.
 */
public data class ResourceDataSyncS3DestinationArgs(
    public val bucketName: Output<String>,
    public val kmsKeyArn: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val region: Output<String>,
    public val syncFormat: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssm.inputs.ResourceDataSyncS3DestinationArgs> {
    override fun toJava(): com.pulumi.aws.ssm.inputs.ResourceDataSyncS3DestinationArgs =
        com.pulumi.aws.ssm.inputs.ResourceDataSyncS3DestinationArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .region(region.applyValue({ args0 -> args0 }))
            .syncFormat(syncFormat?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceDataSyncS3DestinationArgs].
 */
@PulumiTagMarker
public class ResourceDataSyncS3DestinationArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    private var prefix: Output<String>? = null

    private var region: Output<String>? = null

    private var syncFormat: Output<String>? = null

    /**
     * @param value Name of S3 bucket where the aggregated data is stored.
     */
    @JvmName("torosgoslhdqsdbb")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value ARN of an encryption key for a destination in Amazon S3.
     */
    @JvmName("shrcsueomljtvquf")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Prefix for the bucket.
     */
    @JvmName("qkqgugonklhewfdl")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Region with the bucket targeted by the Resource Data Sync.
     */
    @JvmName("obnuxmnwaeyeaiub")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value A supported sync format. Only JsonSerDe is currently supported. Defaults to JsonSerDe.
     */
    @JvmName("covtuofvpbxldcmk")
    public suspend fun syncFormat(`value`: Output<String>) {
        this.syncFormat = value
    }

    /**
     * @param value Name of S3 bucket where the aggregated data is stored.
     */
    @JvmName("yisruqmciqhpnxjw")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value ARN of an encryption key for a destination in Amazon S3.
     */
    @JvmName("lqgwhyrgoifbqwta")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Prefix for the bucket.
     */
    @JvmName("fqaxyuaoljswehgr")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Region with the bucket targeted by the Resource Data Sync.
     */
    @JvmName("covcrviwlnwnsbqq")
    public suspend fun region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value A supported sync format. Only JsonSerDe is currently supported. Defaults to JsonSerDe.
     */
    @JvmName("takshjbhgrysrnrg")
    public suspend fun syncFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncFormat = mapped
    }

    internal fun build(): ResourceDataSyncS3DestinationArgs = ResourceDataSyncS3DestinationArgs(
        bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        kmsKeyArn = kmsKeyArn,
        prefix = prefix,
        region = region ?: throw PulumiNullFieldException("region"),
        syncFormat = syncFormat,
    )
}
