@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key The key describing the location of an attachment to a document. Valid key types include: `SourceUrl` and `S3FileUrl`
 * @property name The name of the document attachment file
 * @property values The value describing the location of an attachment to a document
 */
public data class DocumentAttachmentsSource(
    public val key: String,
    public val name: String? = null,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.DocumentAttachmentsSource):
            DocumentAttachmentsSource = DocumentAttachmentsSource(
            key = javaType.key(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
