@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the filter field. Valid values can be found in the [SSM InstanceInformationStringFilter API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_InstanceInformationStringFilter.html).
 * @property values Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
 */
public data class GetInstancesFilter(
    public val name: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.GetInstancesFilter): GetInstancesFilter =
            GetInstancesFilter(
                name = javaType.name(),
                values = javaType.values().map({ args0 -> args0 }),
            )
    }
}
