@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMaintenanceWindows.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids List of window IDs of the matched SSM maintenance windows.
 */
public data class GetMaintenanceWindowsResult(
    public val filters: List<GetMaintenanceWindowsFilter>? = null,
    public val id: String,
    public val ids: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.GetMaintenanceWindowsResult):
            GetMaintenanceWindowsResult = GetMaintenanceWindowsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.GetMaintenanceWindowsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
        )
    }
}
