@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getParameter.
 * @property arn
 * @property id The provider-assigned unique ID for this managed resource.
 * @property insecureValue
 * @property name
 * @property type
 * @property value
 * @property version
 * @property withDecryption
 */
public data class GetParameterResult(
    public val arn: String,
    public val id: String,
    public val insecureValue: String,
    public val name: String,
    public val type: String,
    public val `value`: String,
    public val version: Int,
    public val withDecryption: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.GetParameterResult): GetParameterResult =
            GetParameterResult(
                arn = javaType.arn(),
                id = javaType.id(),
                insecureValue = javaType.insecureValue(),
                name = javaType.name(),
                type = javaType.type(),
                `value` = javaType.`value`(),
                version = javaType.version(),
                withDecryption = javaType.withDecryption().map({ args0 -> args0 }).orElse(null),
            )
    }
}
