@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getParametersByPath.
 * @property arns A list that contains the Amazon Resource Names (ARNs) of the retrieved parameters.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property names A list that contains the names of the retrieved parameters.
 * @property path
 * @property recursive
 * @property types A list that contains the types (`String`, `StringList`, or `SecureString`) of retrieved parameters.
 * @property values A list that contains the retrieved parameter values. **Note:** This value is always marked as sensitive in the pulumi preview output, regardless of whether any retrieved parameters are of `SecureString` type. Use the `nonsensitive` function to override the behavior at your own risk and discretion, if you are certain that there are no sensitive values being retrieved.
 * @property withDecryption
 */
public data class GetParametersByPathResult(
    public val arns: List<String>,
    public val id: String,
    public val names: List<String>,
    public val path: String,
    public val recursive: Boolean? = null,
    public val types: List<String>,
    public val values: List<String>,
    public val withDecryption: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.GetParametersByPathResult):
            GetParametersByPathResult = GetParametersByPathResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            id = javaType.id(),
            names = javaType.names().map({ args0 -> args0 }),
            path = javaType.path(),
            recursive = javaType.recursive().map({ args0 -> args0 }).orElse(null),
            types = javaType.types().map({ args0 -> args0 }),
            values = javaType.values().map({ args0 -> args0 }),
            withDecryption = javaType.withDecryption().map({ args0 -> args0 }).orElse(null),
        )
    }
}
