@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property approveAfterDays The number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.
 * @property approveUntilDate The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically. Date is formatted as `YYYY-MM-DD`. Conflicts with `approve_after_days`
 * @property complianceLevel The compliance level for patches approved by this rule.
 * @property enableNonSecurity Boolean enabling the application of non-security updates.
 * @property patchFilters The patch filter group that defines the criteria for the rule.
 */
public data class GetPatchBaselineApprovalRule(
    public val approveAfterDays: Int,
    public val approveUntilDate: String,
    public val complianceLevel: String,
    public val enableNonSecurity: Boolean,
    public val patchFilters: List<GetPatchBaselineApprovalRulePatchFilter>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.GetPatchBaselineApprovalRule):
            GetPatchBaselineApprovalRule = GetPatchBaselineApprovalRule(
            approveAfterDays = javaType.approveAfterDays(),
            approveUntilDate = javaType.approveUntilDate(),
            complianceLevel = javaType.complianceLevel(),
            enableNonSecurity = javaType.enableNonSecurity(),
            patchFilters = javaType.patchFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.GetPatchBaselineApprovalRulePatchFilter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
