@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property configuration The value of the yum repo configuration.
 * @property name The name specified to identify the patch source.
 * @property products The specific operating system versions a patch repository applies to.
 */
public data class GetPatchBaselineSource(
    public val configuration: String,
    public val name: String,
    public val products: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.GetPatchBaselineSource):
            GetPatchBaselineSource = GetPatchBaselineSource(
            configuration = javaType.configuration(),
            name = javaType.name(),
            products = javaType.products().map({ args0 -> args0 }),
        )
    }
}
