@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property automationParameters The parameters for an AUTOMATION task type. Documented below.
 * @property lambdaParameters The parameters for a LAMBDA task type. Documented below.
 * @property runCommandParameters The parameters for a RUN_COMMAND task type. Documented below.
 * @property stepFunctionsParameters The parameters for a STEP_FUNCTIONS task type. Documented below.
 */
public data class MaintenanceWindowTaskTaskInvocationParameters(
    public val automationParameters:
    MaintenanceWindowTaskTaskInvocationParametersAutomationParameters? = null,
    public val lambdaParameters: MaintenanceWindowTaskTaskInvocationParametersLambdaParameters? =
        null,
    public val runCommandParameters:
    MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters? = null,
    public val stepFunctionsParameters:
    MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.MaintenanceWindowTaskTaskInvocationParameters):
            MaintenanceWindowTaskTaskInvocationParameters =
            MaintenanceWindowTaskTaskInvocationParameters(
                automationParameters = javaType.automationParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParametersAutomationParameters.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                lambdaParameters = javaType.lambdaParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParameters.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                runCommandParameters = javaType.runCommandParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParameters.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                stepFunctionsParameters = javaType.stepFunctionsParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ssm.kotlin.outputs.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
