@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientContext Pass client-specific information to the Lambda function that you are invoking.
 * @property payload JSON to provide to your Lambda function as input.
 * @property qualifier Specify a Lambda function version or alias name.
 */
public data class MaintenanceWindowTaskTaskInvocationParametersLambdaParameters(
    public val clientContext: String? = null,
    public val payload: String? = null,
    public val qualifier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.MaintenanceWindowTaskTaskInvocationParametersLambdaParameters):
            MaintenanceWindowTaskTaskInvocationParametersLambdaParameters =
            MaintenanceWindowTaskTaskInvocationParametersLambdaParameters(
                clientContext = javaType.clientContext().map({ args0 -> args0 }).orElse(null),
                payload = javaType.payload().map({ args0 -> args0 }).orElse(null),
                qualifier = javaType.qualifier().map({ args0 -> args0 }).orElse(null),
            )
    }
}
